/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.client.lexicon;

import de.sanandrew.mods.sanlib.api.client.lexicon.CraftingGrid;
import de.sanandrew.mods.sanlib.api.client.lexicon.IGuiButtonEntry;
import de.sanandrew.mods.sanlib.api.client.lexicon.IGuiButtonLink;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexicon;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconEntry;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconGroup;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconGuiHelper;
import de.sanandrew.mods.sanlib.client.lexicon.GuiLexicon;
import de.sanandrew.mods.sanlib.client.lexicon.LexiconRegistry;
import de.sanandrew.mods.sanlib.client.lexicon.button.GuiButtonEntry;
import de.sanandrew.mods.sanlib.client.lexicon.button.GuiButtonLink;
import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Deprecated
public class LexiconGuiHelper
implements ILexiconGuiHelper {
    private static final Pattern PATTERN_LINKSTRING = Pattern.compile("\\{link:(.+?)\\|(.+?):(.*?)}");
    private static FontRenderer unicodeFr;
    public final GuiLexicon gui;
    private final Map<ResourceLocation, Boolean> checkedResources;

    LexiconGuiHelper(GuiLexicon gui) {
        this.gui = gui;
        this.checkedResources = new HashMap<ResourceLocation, Boolean>();
    }

    @Override
    public void doEntryScissoring(int x, int y, int width, int height) {
        int prevX = x;
        int yShifted = y - Math.round(this.gui.scroll * (float)this.gui.dHeight);
        int maxWidth = Math.min(width, width - (x + width - this.gui.lexicon.getEntryWidth()));
        int maxHeight = Math.min(height, height - (y + height - this.gui.entryHeight) + Math.round(this.gui.scroll * (float)this.gui.dHeight));
        x = this.gui.entryX + Math.max(0, prevX);
        y = this.gui.entryY + Math.max(0, yShifted);
        width = Math.max(0, Math.min(maxWidth, width + prevX));
        height = Math.max(0, Math.min(maxHeight, height + yShifted));
        GuiUtils.glScissor(x, y, width, height);
    }

    @Override
    public void doEntryScissoring() {
        GuiUtils.glScissor(this.gui.entryX, this.gui.entryY, this.gui.lexicon.getEntryWidth(), this.gui.entryHeight);
    }

    @Override
    public GuiScreen getGui() {
        return this.gui;
    }

    @Override
    public int getGuiX() {
        return this.gui.guiLeft;
    }

    @Override
    public int getGuiY() {
        return this.gui.guiTop;
    }

    @Override
    public int getEntryX() {
        return this.gui.entryX;
    }

    @Override
    public int getEntryY() {
        return this.gui.entryY;
    }

    @Override
    public void setScroll(float scroll) {
        this.gui.scroll = Math.max(0.0f, Math.min(1.0f, scroll));
    }

    @Override
    public void drawItemGrid(int x, int y, int mouseX, int mouseY, int scrollY, @Nonnull ItemStack stack, float scale, boolean drawTooltip) {
        boolean mouseOver;
        this.gui.field_146297_k.func_110434_K().func_110577_a(this.gui.lexicon.getBackgroundTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179147_l();
        this.drawTextureRect(0, 0, 238, 0, 18, 18);
        GlStateManager.func_179121_F();
        float fx = (float)x + 1.0f * scale;
        float fy = (float)y + 1.0f * scale;
        boolean bl = mouseOver = mouseY >= 0 && mouseY < this.gui.entryHeight && (float)mouseX >= fx && (float)mouseX < fx + 16.0f * scale && (float)mouseY >= fy - (float)scrollY && (float)mouseY < fy + 16.0f * scale - (float)scrollY;
        if (mouseOver && ItemStackUtils.isValid(stack)) {
            this.gui.drawFrameLast = () -> {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.gui.entryX, (float)(this.gui.entryY + this.gui.entryHeight - 20), (float)96.0f);
                Gui.func_73734_a((int)0, (int)0, (int)this.gui.lexicon.getEntryWidth(), (int)20, (int)-805306368);
                List<?> tooltip = GuiUtils.getTooltipWithoutShift(stack);
                this.getFontRenderer().func_175065_a(tooltip.get(0).toString(), 22.0f, 2.0f, -1, false);
                if (drawTooltip && tooltip.size() > 1) {
                    this.getFontRenderer().func_175065_a(tooltip.get(1).toString(), 22.0f, 11.0f, -8355712, false);
                }
                RenderUtils.renderStackInGui(stack, 2, 2, 1.0, this.getFontRenderer());
                GlStateManager.func_179121_F();
            };
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)fx, (float)fy, (float)0.0f);
        if (ItemStackUtils.isValid(stack)) {
            RenderUtils.renderStackInGui(stack, 0, 0, scale, this.getFontRenderer());
        }
        if (mouseOver) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)64.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)-2130706433);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawContentString(String str, int x, int y, int wrapWidth, int textColor, List<GuiButton> links) {
        FontRenderer fontRenderer = this.getFontRenderer();
        HashMap<Integer, String> foundLinks = new HashMap<Integer, String>();
        str = LexiconGuiHelper.replaceLinkedText(str, foundLinks);
        int drawnCharacters = 0;
        List<String> lines = this.getSplitString(str, wrapWidth);
        for (String line : lines) {
            int currLength = str.indexOf(line, drawnCharacters);
            int newLength = currLength + line.length();
            List entries = foundLinks.entrySet().stream().filter(entry -> (Integer)entry.getKey() >= currLength && (Integer)entry.getKey() < newLength).sorted(Comparator.comparingInt(Map.Entry::getKey)).collect(Collectors.toCollection(ArrayList::new));
            if (entries.size() > 0) {
                int lastUsedId = 0;
                int lineX = x;
                for (Map.Entry entry2 : entries) {
                    String s = line.substring(lastUsedId, (Integer)entry2.getKey() - currLength);
                    int sl = fontRenderer.func_78256_a(s);
                    fontRenderer.func_175065_a(s, (float)lineX, (float)y, textColor, false);
                    lineX += sl;
                    int entrySplitId = ((String)entry2.getValue()).indexOf(124);
                    String t = ((String)entry2.getValue()).substring(0, entrySplitId);
                    int tl = fontRenderer.func_78256_a(t);
                    if (links != null) {
                        GuiButton lnk = links.stream().filter(button -> button.field_146127_k == (Integer)entry2.getKey()).findFirst().orElse(null);
                        if (lnk == null) {
                            lnk = new GuiButtonLink(this.gui, (Integer)entry2.getKey(), lineX, y, t, ((String)entry2.getValue()).substring(entrySplitId + 1), this.getFontRenderer());
                            links.add(lnk);
                        } else {
                            lnk.field_146128_h = lineX;
                            lnk.field_146129_i = y;
                        }
                    } else {
                        fontRenderer.func_175065_a(t, (float)lineX, (float)y, textColor, false);
                    }
                    lineX += tl;
                    lastUsedId += s.length() + t.length();
                }
                if (lastUsedId < line.length()) {
                    fontRenderer.func_175065_a(line.substring(lastUsedId), (float)lineX, (float)y, textColor, false);
                }
            } else {
                fontRenderer.func_175065_a(line, (float)x, (float)y, textColor, false);
            }
            y += fontRenderer.field_78288_b;
            drawnCharacters = newLength;
        }
    }

    @Override
    public int getWordWrappedHeight(String str, int wrapWidth) {
        return this.getFontRenderer().field_78288_b * this.getSplitString(str, wrapWidth).size();
    }

    private List<String> getSplitString(String str, int wrapWidth) {
        FontRenderer fr = this.getFontRenderer();
        return Arrays.stream(LexiconGuiHelper.replaceLinkedText(str, null).split("\n")).collect(ArrayList::new, (list, elem) -> list.addAll(fr.func_78271_c(elem, wrapWidth)), ArrayList::addAll);
    }

    private static String replaceLinkedText(String str, Map<Integer, String> links) {
        Matcher matcher;
        while ((matcher = PATTERN_LINKSTRING.matcher(str)).find()) {
            if (links != null) {
                String[] linkSplit = matcher.group(1).split(" ");
                int currInd = matcher.start();
                for (int i = 0; i < linkSplit.length; ++i) {
                    StringBuilder txt = new StringBuilder(linkSplit[i]);
                    if (i < linkSplit.length - 1) {
                        txt.append('\u00a0');
                    }
                    links.put(currInd, String.format("%s|%s:%s", txt, matcher.group(2), matcher.group(3)));
                    currInd += txt.length();
                }
            }
            str = matcher.replaceFirst("$1");
        }
        return str;
    }

    @Override
    public FontRenderer getFontRenderer() {
        if (this.gui.lexicon.forceUnicode()) {
            if (unicodeFr == null) {
                unicodeFr = new FontRenderer(this.gui.field_146297_k.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.gui.field_146297_k.field_71446_o, true);
            }
            return unicodeFr;
        }
        return this.gui.field_146297_k.field_71466_p;
    }

    @Override
    public void drawItem(@Nonnull ItemStack stack, int x, int y, double scale) {
        RenderUtils.renderStackInGui(stack, x, y, scale);
    }

    @Override
    public void drawTextureRect(int x, int y, int u, int v, int w, int h) {
        this.gui.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTextureRect(int x, int y, int w, int h, float uMin, float vMin, float uMax, float vMax) {
        float z = this.gui.getZLevel();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)uMin, (double)vMax).func_181675_d();
        buf.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)uMax, (double)vMax).func_181675_d();
        buf.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)uMax, (double)vMin).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)uMin, (double)vMin).func_181675_d();
        tess.func_78381_a();
    }

    @Override
    public void drawRect(int x, int y, int w, int h, int color) {
        Gui.func_73734_a((int)x, (int)y, (int)w, (int)h, (int)color);
    }

    @Override
    public void changePage(ILexiconGroup group, ILexiconEntry entry) {
        this.gui.changePage(group, entry, 0.0f, true);
    }

    @Override
    public boolean tryLoadTexture(ResourceLocation location) {
        if (location == null) {
            return false;
        }
        if (this.checkedResources.containsKey(location)) {
            if (this.checkedResources.get(location).booleanValue()) {
                this.gui.field_146297_k.field_71446_o.func_110577_a(location);
                return true;
            }
            return false;
        }
        try {
            if (this.gui.field_146297_k.field_71446_o.func_110581_b(location) == null) {
                new SimpleTexture(location).func_110551_a(this.gui.field_146297_k.func_110442_L());
            }
        }
        catch (IOException ex) {
            this.checkedResources.put(location, false);
            return false;
        }
        this.gui.field_146297_k.field_71446_o.func_110577_a(location);
        this.checkedResources.put(location, true);
        return true;
    }

    @Override
    public boolean linkActionPerformed(GuiButton button) {
        if (button instanceof GuiButtonLink) {
            GuiButtonLink btnLink = (GuiButtonLink)button;
            if (btnLink.getLink().startsWith("http://") || btnLink.getLink().startsWith("https://")) {
                return false;
            }
            int groupCharId = btnLink.getLink().indexOf(58);
            String groupId = btnLink.getLink().substring(0, groupCharId);
            String entryId = btnLink.getLink().substring(groupCharId + 1);
            ILexiconGroup group = LexiconRegistry.INSTANCE.getInstance(this.gui.lexicon.getModId()).getGroup(groupId);
            if (group != null) {
                this.changePage(group, group.getEntry(entryId));
            }
            return true;
        }
        return false;
    }

    @Override
    public void initCraftings(@Nonnull NonNullList<IRecipe> recipes, List<CraftingGrid> grids) {
        int w = 0;
        int h = 0;
        ArrayList<IRecipe> allRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : recipes) {
            if (recipe instanceof ShapedRecipes) {
                w = Math.max(w, ((ShapedRecipes)recipe).field_77576_b);
                h = Math.max(h, ((ShapedRecipes)recipe).field_77577_c);
            } else if (recipe instanceof ShapedOreRecipe) {
                w = Math.max(w, ((ShapedOreRecipe)recipe).getRecipeWidth());
                h = Math.max(h, ((ShapedOreRecipe)recipe).getRecipeHeight());
            } else {
                int ingredientSize = recipe.func_192400_c().size();
                w = Math.max(w, MathHelper.func_76123_f((float)MathHelper.func_76129_c((float)ingredientSize)));
                h = Math.max(h, MathHelper.func_76123_f((float)((float)ingredientSize / (float)w)));
            }
            allRecipes.add(recipe);
        }
        for (IRecipe currRecipe : allRecipes) {
            grids.add(new CraftingGrid(w, h, currRecipe));
        }
    }

    @Override
    public Vec3i getCraftingGridSize(CraftingGrid grid) {
        return new Vec3i(grid.getWidth() * 18 + 4 + 18 + 36, Math.max(grid.getHeight() * 18, 36), 0);
    }

    @Override
    public void drawCraftingGrid(CraftingGrid grid, boolean isShapeless, int x, int y, int mouseX, int mouseY, int scrollY) {
        int mX = grid.getWidth();
        int mY = grid.getHeight();
        this.drawItemGrid(x + mX * 18 + 4 + 18, y + Math.max(mY * 9 - 18, 0), mouseX, mouseY, scrollY, grid.getResult(), 2.0f, false);
        this.tryLoadTexture(this.gui.lexicon.getBackgroundTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.drawTextureRect(x + mX * 18 + 2, y + 12 + Math.max(mY * 9 - 18, 0), 238, isShapeless ? 30 : 18, 18, 12);
        for (int gx = 0; gx < mX; ++gx) {
            for (int gy = 0; gy < mY; ++gy) {
                NonNullList<ItemStack> drawnStacks = grid.getItemsAt(gx, gy);
                ItemStack drawnStack = drawnStacks.size() > 0 ? (ItemStack)drawnStacks.get((int)(System.nanoTime() / 1000000000L % (long)drawnStacks.size())) : ItemStack.field_190927_a;
                this.drawItemGrid(x + gx * 18, y + gy * 18 + Math.max(27 - mY * 18, 0), mouseX, mouseY, scrollY, drawnStack, 1.0f, true);
            }
        }
    }

    @Override
    public boolean tryDrawPicture(ResourceLocation location, int x, int y, int width, int height) {
        if (this.tryLoadTexture(location)) {
            this.drawRect(x, y, x + width, y + height, -16777216);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTextureRect(x + 1, y + 1, width - 2, height - 2, 0.0f, 0.0f, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public ILexicon getLexicon() {
        return this.gui.lexicon;
    }

    @Override
    public void drawTitleCenter(int y, ILexiconEntry entry) {
        String s = this.getTitle(entry);
        this.getFontRenderer().func_78276_b(s, (this.getLexicon().getEntryWidth() - this.getFontRenderer().func_78256_a(s)) / 2, y, this.getLexicon().getTitleColor());
    }

    @Override
    public void drawTitle(int x, int y, ILexiconEntry entry) {
        this.getFontRenderer().func_78276_b(this.getTitle(entry), x, y, this.getLexicon().getTitleColor());
    }

    private String getTitle(ILexiconEntry entry) {
        return TextFormatting.ITALIC.toString() + TextFormatting.BOLD + LangUtils.translate(entry.getTitleLangKey(this.getLexicon().getModId()), new Object[0]);
    }

    @Override
    public int drawContentString(int x, int y, ILexiconEntry entry, List<GuiButton> links) {
        int entryWidth = this.getLexicon().getEntryWidth();
        String s = LangUtils.translate(LangUtils.LEXICON_ENTRY_TEXT.get(this.getLexicon().getModId(), entry.getGroupId(), entry.getId()), new Object[0]).replace("\\n", "\n");
        this.drawContentString(s, x, y, entryWidth - x * 2, this.getLexicon().getTextColor(), links);
        return this.getWordWrappedHeight(s, entryWidth - x * 2) + 3;
    }

    @Override
    public IGuiButtonEntry getNewEntryButton(int id, int x, int y, ILexiconEntry entry, FontRenderer fontRenderer) {
        return new GuiButtonEntry(this.gui, id, x, y, entry, fontRenderer);
    }

    @Override
    public IGuiButtonLink getNewLinkButton(int id, int x, int y, String text, String link, FontRenderer fontRenderer) {
        return new GuiButtonLink(this.gui, id, x, y, text, link, fontRenderer);
    }

    @Override
    public IGuiButtonLink getNewLinkButton(int id, int x, int y, String text, String link, FontRenderer fontRenderer, boolean trusted) {
        return new GuiButtonLink(this.gui, id, x, y, text, link, fontRenderer, trusted);
    }

    @Override
    public List<GuiButton> getEntryButtonList() {
        return this.gui.entryButtons;
    }

    @Override
    public List<GuiButton> getGuiButtonList() {
        return this.gui.getButtonList();
    }

    @Override
    public NonNullList<IRecipe> getMatchingRecipes(ItemStack output) {
        NonNullList recipes = NonNullList.func_191196_a();
        StreamSupport.stream(CraftingManager.field_193380_a.spliterator(), false).filter(r -> !r.func_192399_d() && ItemStackUtils.areEqualNbtFit(output, r.func_77571_b(), false, true, false) && r.func_194133_a(3, 3)).findFirst().ifPresent(arg_0 -> recipes.add(arg_0));
        return recipes;
    }
}

