/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.client.lexicon.search;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.sanandrew.mods.sanlib.api.client.lexicon.IGuiButtonEntry;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconEntry;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconGroup;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconGuiHelper;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconPageRender;
import de.sanandrew.mods.sanlib.client.lexicon.LexiconRegistry;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Deprecated
public class LexiconRenderSearch
implements ILexiconPageRender {
    public static final String RENDER_SEARCH_ID = "sanlib:search";
    public static final int TYPE_TXT_HEIGHT = 12;
    public static final int GROUP_TXT_HEIGHT = 12;
    public static final int ENTRY_BTN_HEIGHT = 14;
    private int drawHeight;
    private List<GuiButton> entryButtons;
    private GuiTextField search;
    private String lastFilterText;
    private final Table<String, String, IGuiButtonEntry> allEntries = HashBasedTable.create();
    private final Table<ILexiconGroup, Boolean, List<IGuiButtonEntry>> visibleEntries = HashBasedTable.create();

    @Override
    public String getId() {
        return RENDER_SEARCH_ID;
    }

    @Override
    public int shiftEntryPosY() {
        return 16;
    }

    @Override
    public void initPage(ILexiconEntry entry, ILexiconGuiHelper helper, List<GuiButton> globalButtons, List<GuiButton> entryButtons) {
        this.entryButtons = entryButtons;
        this.lastFilterText = "\u00a0";
        this.search = new GuiTextField(0, helper.getFontRenderer(), helper.getLexicon().getEntryPosX() + 1, helper.getLexicon().getEntryPosY() + 1, helper.getLexicon().getEntryWidth() + 4, 12);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        LexiconRegistry.INSTANCE.getInstance(helper.getLexicon().getModId()).getGroups().forEach(grp -> grp.getEntries().forEach(ntry -> {
            if (!ntry.getSrcText().isEmpty() && !ntry.getSrcTitle().isEmpty()) {
                IGuiButtonEntry btn = helper.getNewEntryButton(this.entryButtons.size(), 6, 0, (ILexiconEntry)ntry, helper.getFontRenderer());
                btn.get().field_146125_m = false;
                this.entryButtons.add(btn.get());
                this.allEntries.put((Object)ntry.getSrcTitle(), (Object)ntry.getSrcText(), (Object)btn);
            }
        }));
    }

    @Override
    public void updateScreen(ILexiconGuiHelper helper) {
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.drawHeight = 0;
            this.lastFilterText = this.search.func_146179_b();
            this.visibleEntries.clear();
            helper.setScroll(0.0f);
            Pattern filter = Pattern.compile(".*?" + this.lastFilterText + ".*", 2);
            this.allEntries.cellSet().forEach(cell -> {
                IGuiButtonEntry btn = (IGuiButtonEntry)Objects.requireNonNull(cell.getValue());
                boolean matchedByTitle = filter.matcher((CharSequence)Objects.requireNonNull(cell.getRowKey())).matches();
                boolean bl = btn.get().field_146125_m = matchedByTitle || filter.matcher((CharSequence)Objects.requireNonNull(cell.getColumnKey())).matches();
                if (btn.get().field_146125_m) {
                    ILexiconGroup group = LexiconRegistry.INSTANCE.getInstance(helper.getLexicon().getModId()).getGroup(btn.getEntry().getGroupId());
                    ArrayList<IGuiButtonEntry> btnList = (ArrayList<IGuiButtonEntry>)this.visibleEntries.get((Object)group, (Object)matchedByTitle);
                    if (btnList == null) {
                        btnList = new ArrayList<IGuiButtonEntry>();
                        this.visibleEntries.put((Object)group, (Object)matchedByTitle, btnList);
                    }
                    btnList.add(btn);
                }
            });
            Arrays.stream(new Boolean[]{true, false}).forEach(b -> {
                this.drawHeight += this.visibleEntries.column(b).size() > 0 ? 12 : 0;
                this.visibleEntries.column(b).forEach((group, entries) -> {
                    this.drawHeight += 12;
                    entries.forEach(btn -> {
                        btn.get().field_146129_i = this.drawHeight;
                        this.drawHeight += 14;
                    });
                    this.drawHeight += 2;
                });
            });
        }
    }

    @Override
    public void renderPageOverlay(ILexiconEntry entry, ILexiconGuiHelper helper, int mouseX, int mouseY, float partTicks) {
        this.search.func_146194_f();
    }

    @Override
    public void renderPageEntry(ILexiconEntry entry, ILexiconGuiHelper helper, int mouseX, int mouseY, int scrollY, float partTicks) {
        this.drawHeight = 0;
        Arrays.stream(new Boolean[]{true, false}).forEach(b -> {
            if (this.visibleEntries.column(b).size() > 0) {
                String langKey = (b != false ? LangUtils.LEXICON_SRC_ENTRY_TITLE : LangUtils.LEXICON_SRC_ENTRY_TEXT).get(helper.getLexicon().getModId());
                helper.getFontRenderer().func_78276_b(LangUtils.translate(langKey, new Object[0]), 2, this.drawHeight, -8355712);
                this.drawHeight += 12;
                this.visibleEntries.column(b).forEach((group, entries) -> {
                    helper.getFontRenderer().func_78276_b(LangUtils.translate(LangUtils.LEXICON_GROUP_NAME.get(helper.getLexicon().getModId(), group.getId()), new Object[0]), 6, this.drawHeight, helper.getLexicon().getTitleColor());
                    this.drawHeight += 12 + entries.size() * 14 + 2;
                });
            }
        });
    }

    @Override
    public int getEntryHeight(ILexiconEntry entry, ILexiconGuiHelper helper) {
        return this.drawHeight;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseBtn, ILexiconGuiHelper helper) {
        this.search.func_146192_a(mouseX -= helper.getGuiX(), mouseY -= helper.getGuiY(), mouseBtn);
        if (mouseBtn == 1 && mouseX >= this.search.field_146209_f && mouseX < this.search.field_146209_f + this.search.field_146218_h && mouseY >= this.search.field_146210_g && mouseY < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode, ILexiconGuiHelper helper) {
        this.search.func_146201_a(typedChar, keyCode);
    }

    @Override
    public void savePageState(NBTTagCompound nbt) {
        nbt.func_74778_a("searchString", this.search.func_146179_b());
    }

    @Override
    public void loadPageState(NBTTagCompound nbt) {
        if (nbt.func_74764_b("searchString")) {
            this.search.func_146180_a(nbt.func_74779_i("searchString"));
        }
    }
}

