/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.client.lexicon2;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ScrollArea;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class GuiLexicon
extends GuiScreen
implements IGui {
    private static final List<Lexicon> LEXICA = new ArrayList<Lexicon>();
    private final GuiDefinition guiDef;
    public GuiElementInst contentPane;
    protected int posX;
    protected int posY;

    public GuiLexicon(int lexiconId) throws IOException {
        this.guiDef = GuiLexicon.LEXICA.get(lexiconId).load();
        this.contentPane = this.guiDef.getElementById("contentPane");
        if (this.contentPane == null || !(this.contentPane.get() instanceof ContentPane)) {
            throw new InvalidObjectException(String.format("There must be an element with the ID \"contentPane\" of type or a subclass of %s", ContentPane.class));
        }
    }

    public GuiLexicon(int lexiconId, ResourceLocation page) throws IOException {
        this(lexiconId);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.posX = (this.field_146294_l - this.guiDef.width) / 2;
        this.posY = (this.field_146295_m - this.guiDef.height) / 2;
        this.guiDef.initGui(this);
    }

    public void func_73876_c() {
        this.guiDef.update(this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        this.guiDef.drawBackground(this, mouseX, mouseY, partialTicks);
        this.guiDef.drawForeground(this, mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.guiDef.handleMouseInput(this);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.guiDef.mouseClicked(this, mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.guiDef.mouseReleased(this, mouseX, mouseY, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.guiDef.mouseClickMove(this, mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.guiDef.keyTyped(this, typedChar, keyCode);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.guiDef.guiClosed(this);
    }

    @Override
    public boolean performAction(IGuiElement element, int action) {
        return false;
    }

    @Override
    public GuiScreen get() {
        return this;
    }

    @Override
    public GuiDefinition getDefinition() {
        return this.guiDef;
    }

    @Override
    public int getScreenPosX() {
        return this.posX;
    }

    @Override
    public int getScreenPosY() {
        return this.posY;
    }

    public static int register(ResourceLocation lexiconFolder) {
        Lexicon reg = new Lexicon(lexiconFolder);
        LEXICA.add(reg);
        return LEXICA.indexOf(reg);
    }

    private static ResourceLocation getResource(ResourceLocation folder, String path) {
        return new ResourceLocation(folder.func_110624_b(), folder.func_110623_a() + "/" + path);
    }

    static {
        GuiDefinition.TYPES.put(new ResourceLocation("sanlib", "lexicon_content_area"), ContentPane::new);
    }

    private static class Lexicon {
        private final ResourceLocation path;
        private final Map<ResourceLocation, Page> pages = new HashMap<ResourceLocation, Page>();
        private Page currentPage;

        Lexicon(ResourceLocation path) {
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GuiDefinition load() throws IOException {
            IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
            HashSet pages = new HashSet();
            GuiDefinition def = GuiDefinition.getNewDefinition(GuiLexicon.getResource(this.path, "lexicon.json"));
            def.width = 192;
            def.height = 236;
            List pagesDefs = null;
            try {
                pagesDefs = Lists.reverse((List)resourceManager.func_135056_b(GuiLexicon.getResource(this.path, "pages.json")));
                for (IResource r : pagesDefs) {
                    InputStreamReader reader = new InputStreamReader(r.func_110527_b(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        JsonElement json = new JsonParser().parse((Reader)reader);
                        if (!json.isJsonArray()) continue;
                        Arrays.stream(JsonUtils.getStringArray(json)).forEach(s -> {
                            ResourceLocation pageLocation = new ResourceLocation(s);
                            try (IResource rs = resourceManager.func_110536_a(pageLocation);
                                 InputStream is = rs.func_110527_b();
                                 InputStreamReader isr = new InputStreamReader(is);){
                                JsonObject jObj = (JsonObject)JsonUtils.GSON.fromJson((Reader)isr, JsonObject.class);
                                this.pages.computeIfAbsent(pageLocation, rp -> new Page(jObj));
                            }
                            catch (IOException e) {
                                SanLib.LOG.log(Level.ERROR, "Cannot load page", (Throwable)e);
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
            }
            finally {
                if (pagesDefs != null) {
                    for (IResource r : pagesDefs) {
                        r.close();
                    }
                }
            }
            return def;
        }
    }

    public static class Page {
        public final ResourceLocation parent;
        public final ItemStack icon;
        public final String title;
        public final GuiElementInst[] pageElements;
        public final GuiElementInst[] globalElements;

        public Page(JsonObject json) {
            this.parent = JsonUtils.getLocation(json.get("parent"), null);
            this.icon = JsonUtils.getItemStack(json.get("icon"));
            this.title = JsonUtils.getStringVal(json.get("title"));
            this.pageElements = (GuiElementInst[])JsonUtils.GSON.fromJson(json.get("elements"), GuiElementInst[].class);
            this.globalElements = json.has("globalElements") ? (GuiElementInst[])JsonUtils.GSON.fromJson(json.get("elements"), GuiElementInst[].class) : null;
        }
    }

    public static class ContentPane
    extends ScrollArea {
        private GuiElementInst[] elements = new GuiElementInst[0];

        @Override
        public GuiElementInst[] getElements(IGui gui, JsonObject elementData) {
            return this.elements;
        }
    }
}

