/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.client.model.EmissiveModelLoader;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.SanLibDeserializers;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.vector.Vector3f;

public class EmissiveModel
implements IModel {
    private final IModel parent;
    private final ModelLoader loader;
    private final Map<BlockPartFace, Boolean> emissiveFlags = new HashMap<BlockPartFace, Boolean>();
    private static final VertexFormat ITEM_FORMAT_WITH_LIGHTMAP = new VertexFormat(DefaultVertexFormats.field_176599_b).func_181721_a(DefaultVertexFormats.field_181716_p);

    EmissiveModel(ResourceLocation location, IResourceManager resMgr, ModelLoader loader) {
        this.loader = loader;
        ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation((IResourceManager)resMgr, (ResourceLocation)EmissiveModel.getArmatureLocation(location));
        ModelBlock model = null;
        try (IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json"));
             InputStreamReader reader = new InputStreamReader(res.func_110527_b(), StandardCharsets.UTF_8);){
            Gson modelSerializer = new GsonBuilder().registerTypeAdapter(ModelBlock.class, (Object)new ModelBlock.Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new EmissiveBlockPartDeserializer()).registerTypeAdapter(BlockPartFace.class, (Object)SanLibDeserializers.getForBlockPartFace()).registerTypeAdapter(BlockFaceUV.class, (Object)SanLibDeserializers.getForBlockFaceUV()).registerTypeAdapter(ItemTransformVec3f.class, (Object)SanLibDeserializers.getForItemTransformVec3f()).registerTypeAdapter(ItemCameraTransforms.class, (Object)SanLibDeserializers.getForItemCameraTransforms()).registerTypeAdapter(ItemOverrideList.class, (Object)SanLibDeserializers.getForItemOverride()).create();
            model = JsonUtils.gsonDeserialize(modelSerializer, reader, ModelBlock.class, false);
            Objects.requireNonNull(model).field_178317_b = location.toString();
        }
        catch (IOException | NullPointerException e) {
            SanLib.LOG.log(Level.ERROR, "Cannot deserialize model JSON", (Throwable)e);
        }
        this.parent = EmissiveModel.getVanillaModelWrapper(loader, location, model, animation);
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.parent.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.parent.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        FaceBakery prevBakery = this.loader.field_177607_l;
        this.loader.field_177607_l = new EmissiveFaceBakery();
        IBakedModel model = this.parent.bake(state, format, bakedTextureGetter);
        this.loader.field_177607_l = prevBakery;
        return model;
    }

    public IModelState getDefaultState() {
        return this.parent.getDefaultState();
    }

    private static ResourceLocation getArmatureLocation(ResourceLocation location) {
        String p = location.func_110623_a();
        return new ResourceLocation(location.func_110624_b(), p.startsWith("models/") ? p.substring("models/".length()) : p);
    }

    private static <M extends IModel> M getVanillaModelWrapper(ModelLoader modelLoader, ResourceLocation location, ModelBlock model, ModelBlockAnimation animation) {
        Object vmw = ReflectionUtils.getNew(ModelLoader.class.getName() + "$VanillaModelWrapper", new Class[]{ModelLoader.class, ResourceLocation.class, ModelBlock.class, Boolean.TYPE, ModelBlockAnimation.class}, modelLoader, location, model, false, animation);
        return (M)((IModel)ReflectionUtils.getCasted(vmw));
    }

    private static VertexFormat getFormatWithLightMap(VertexFormat format) {
        if (!EmissiveModelLoader.isLightMapEnabled()) {
            return format;
        }
        if (format == DefaultVertexFormats.field_176600_a) {
            return DefaultVertexFormats.field_176600_a;
        }
        if (format == DefaultVertexFormats.field_176599_b) {
            return ITEM_FORMAT_WITH_LIGHTMAP;
        }
        if (!format.func_177347_a(1)) {
            return new VertexFormat(format).func_181721_a(DefaultVertexFormats.field_181716_p);
        }
        return format;
    }

    public Optional<ModelBlock> asVanillaModel() {
        return this.parent.asVanillaModel();
    }

    public class EmissiveFaceBakery
    extends FaceBakery {
        public BakedQuad makeBakedQuad(Vector3f posFrom, Vector3f posTo, BlockPartFace face, TextureAtlasSprite sprite, EnumFacing facing, ITransformation modelRotationIn, BlockPartRotation partRotation, boolean uvLocked, boolean shade) {
            BakedQuad quad = super.makeBakedQuad(posFrom, posTo, face, sprite, facing, modelRotationIn, partRotation, uvLocked, shade);
            if (EmissiveModel.this.emissiveFlags.computeIfAbsent(face, f -> false).booleanValue()) {
                VertexFormat newFormat = EmissiveModel.getFormatWithLightMap(quad.getFormat());
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
                VertexLighterFlat vlf = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

                    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                        lightmap[0] = 0.007f;
                        lightmap[1] = 0.007f;
                    }
                };
                vlf.setParent((IVertexConsumer)builder);
                quad.pipe((IVertexConsumer)vlf);
                builder.setQuadTint(quad.func_178211_c());
                builder.setQuadOrientation(quad.func_178210_d());
                builder.setTexture(quad.func_187508_a());
                builder.setApplyDiffuseLighting(false);
                return builder.build();
            }
            return quad;
        }
    }

    class EmissiveBlockPartDeserializer
    implements JsonDeserializer<BlockPart> {
        private final JsonDeserializer<BlockPart> parent = SanLibDeserializers.getForBlockPart();

        EmissiveBlockPartDeserializer() {
        }

        public BlockPart deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BlockPart part = (BlockPart)this.parent.deserialize(json, typeOfT, context);
            part.field_178240_c.forEach((face, partFace) -> EmissiveModel.this.emissiveFlags.put(partFace, JsonUtils.getBoolVal(json.getAsJsonObject().get("emissive"), false)));
            return part;
        }
    }
}

