/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib;

public final class ColorObj {
    private int r;
    private int g;
    private int b;
    private int a;

    public static ColorObj fromHSLA(float hue, float saturation, float luminance, float alpha) {
        ColorObj obj = new ColorObj();
        obj.calcAndSetRgbFromHsl(hue, saturation, luminance);
        obj.a = (int)(alpha < 0.0f ? 0.0f : (alpha > 1.0f ? 255.0f : alpha * 255.0f));
        return obj;
    }

    private ColorObj() {
    }

    public ColorObj(int argb) {
        this.a = argb >> 24 & 0xFF;
        this.r = argb >> 16 & 0xFF;
        this.g = argb >> 8 & 0xFF;
        this.b = argb & 0xFF;
    }

    public ColorObj(int red, int green, int blue, int alpha) {
        int n = red < 0 ? 0 : (this.r = red > 255 ? 255 : red);
        int n2 = green < 0 ? 0 : (this.g = green > 255 ? 255 : green);
        int n3 = blue < 0 ? 0 : (this.b = blue > 255 ? 255 : blue);
        this.a = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
    }

    public ColorObj(float red, float green, float blue, float alpha) {
        this.r = (int)(red < 0.0f ? 0.0f : (red > 1.0f ? 255.0f : red * 255.0f));
        this.g = (int)(green < 0.0f ? 0.0f : (green > 1.0f ? 255.0f : green * 255.0f));
        this.b = (int)(blue < 0.0f ? 0.0f : (blue > 1.0f ? 255.0f : blue * 255.0f));
        this.a = (int)(alpha < 0.0f ? 0.0f : (alpha > 1.0f ? 255.0f : alpha * 255.0f));
    }

    public ColorObj(ColorObj orig) {
        this.r = orig.r;
        this.g = orig.g;
        this.b = orig.b;
        this.a = orig.a;
    }

    public int red() {
        return this.r;
    }

    public float fRed() {
        return (float)this.r / 255.0f;
    }

    public int green() {
        return this.g;
    }

    public float fGreen() {
        return (float)this.g / 255.0f;
    }

    public int blue() {
        return this.b;
    }

    public float fBlue() {
        return (float)this.b / 255.0f;
    }

    public int alpha() {
        return this.a;
    }

    public float fAlpha() {
        return (float)this.a / 255.0f;
    }

    public void setRed(int red) {
        this.r = red < 0 ? 0 : (red > 255 ? 255 : red);
    }

    public void setGreen(int green) {
        this.g = green < 0 ? 0 : (green > 255 ? 255 : green);
    }

    public void setBlue(int blue) {
        this.b = blue < 0 ? 0 : (blue > 255 ? 255 : blue);
    }

    public void setAlpha(int alpha) {
        this.a = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
    }

    public int getColorInt() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public float[] calcHSL() {
        float[] hsl = new float[3];
        int min = Math.min(this.r, Math.min(this.g, this.b));
        int max = Math.max(this.r, Math.max(this.g, this.b));
        hsl[2] = (float)(min + max) / 510.0f;
        if (min == max) {
            hsl[0] = 0.0f;
            hsl[1] = 0.0f;
        } else {
            hsl[1] = hsl[2] < 0.5f ? (float)(max - min) / (float)(max + min) : (float)(max - min) / (510.0f - (float)max - (float)min);
            hsl[0] = max == this.r ? (float)(this.g - this.b) / (float)(max - min) * 60.0f : (max == this.g ? (2.0f + (float)(this.b - this.r) / (float)(max - min)) * 60.0f : (4.0f + (float)(this.r - this.g) / (float)(max - min)) * 60.0f);
            if (hsl[0] < 0.0f) {
                hsl[0] = hsl[0] + 360.0f;
            }
        }
        return hsl;
    }

    public void calcAndSetRgbFromHsl(float hue, float saturation, float luminance) {
        float c = (1.0f - Math.abs(2.0f * luminance - 1.0f)) * saturation;
        float x = c * (1.0f - Math.abs((hue %= 360.0f) / 60.0f % 2.0f - 1.0f));
        float m = luminance - c / 2.0f;
        float[] rgb = new float[]{0.0f, 0.0f, 0.0f};
        if (hue < 60.0f) {
            rgb = new float[]{c, x, 0.0f};
        } else if (hue < 120.0f) {
            rgb = new float[]{x, c, 0.0f};
        } else if (hue < 180.0f) {
            rgb = new float[]{0.0f, c, x};
        } else if (hue < 240.0f) {
            rgb = new float[]{0.0f, x, c};
        } else if (hue < 300.0f) {
            rgb = new float[]{x, 0.0f, c};
        } else if (hue < 360.0f) {
            rgb = new float[]{c, 0.0f, x};
        }
        rgb = new float[]{(rgb[0] + m) * 255.0f, (rgb[1] + m) * 255.0f, (rgb[2] + m) * 255.0f};
        this.r = Math.round(rgb[0]);
        this.g = Math.round(rgb[1]);
        this.b = Math.round(rgb[2]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorObj) {
            return this.equals((ColorObj)obj, this.a == 255);
        }
        return super.equals(obj);
    }

    public boolean equals(ColorObj clr, boolean checkAlpha) {
        return this.r == clr.r && this.g == clr.g && this.b == clr.b && (!checkAlpha || this.a == clr.a);
    }
}

