/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib;

import de.sanandrew.mods.sanlib.SanLib;
import io.netty.handler.codec.serialization.ObjectDecoderInputStream;
import io.netty.handler.codec.serialization.ObjectEncoderOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.logging.log4j.Level;

public class Tuple
implements Serializable,
Comparable<Tuple>,
Iterable<Object> {
    private static final long serialVersionUID = -287900116776462007L;
    private final Data<?>[] values;

    public Tuple(Object ... values) {
        this.values = (Data[])Arrays.stream(values).map(x$0 -> new Data(x$0)).toArray(Data[]::new);
    }

    public Object[] toArray() {
        return Arrays.stream(this.values).map(val -> ((Data)val).value).toArray(Object[]::new);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Tuple && Arrays.equals(this.values, ((Tuple)obj).values);
    }

    public <T> T getValue(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new IllegalArgumentException(String.format("Cannot get tuple value! Index %d out of range", index));
        }
        return (T)((Data)this.values[index]).value;
    }

    public <T> boolean checkValue(int index, Function<T, Boolean> checkMtd) {
        return checkMtd.apply(this.getValue(index));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tuple readFromStream(InputStream stream) {
        try (ObjectDecoderInputStream odis = new ObjectDecoderInputStream(stream);){
            Tuple tuple = (Tuple)odis.readObject();
            return tuple;
        }
        catch (IOException | ClassNotFoundException ex) {
            SanLib.LOG.log(Level.ERROR, "Cannot deserialize Tuple!", (Throwable)ex);
            return null;
        }
    }

    public void writeToStream(OutputStream stream) {
        try (ObjectEncoderOutputStream oeos = new ObjectEncoderOutputStream(stream);){
            oeos.writeObject((Object)this);
        }
        catch (IOException ex) {
            SanLib.LOG.log(Level.ERROR, "Cannot serialize Tuple!", (Throwable)ex);
        }
    }

    @Override
    public int compareTo(Tuple o) {
        if (o == this) {
            return 0;
        }
        int tLen = this.values.length;
        int oLen = o.values.length;
        for (int i = 0; i < tLen && i < oLen; ++i) {
            int comparison = this.values[i].compareTo(o.values[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(tLen, oLen);
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.stream(this.values).map(data -> ((Data)data).value).iterator();
    }

    private static class Data<T>
    implements Serializable,
    Comparable<Data<?>> {
        private static final long serialVersionUID = -7494878631121169815L;
        private final T value;

        private Data(T value) {
            this.value = value;
        }

        @Override
        public int compareTo(Data<?> o) {
            if (o == this) {
                return 0;
            }
            if (this.value instanceof Comparable && o.value instanceof Comparable) {
                return ((Comparable)this.value).compareTo(o.value);
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return obj instanceof Data && (this.value == null && ((Data)obj).value == null || this.value != null && this.value.equals(((Data)obj).value));
        }
    }
}

