/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib;

import java.util.concurrent.atomic.AtomicLong;

public final class XorShiftRandom {
    private long seed;
    private double nextGaussian;
    private boolean haveNextGaussian;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final String BAD_BOUND = "bound must be positive";
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);

    public XorShiftRandom() {
        this.setSeed(XorShiftRandom.seedUniquifier() ^ System.nanoTime());
    }

    public XorShiftRandom(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.seed = seed == 0L ? -559038737L : seed;
        this.haveNextGaussian = false;
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!SEED_UNIQUIFIER.compareAndSet(current = SEED_UNIQUIFIER.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    private long rng() {
        this.seed ^= this.seed << 21;
        this.seed ^= this.seed >>> 35;
        this.seed ^= this.seed << 4;
        return this.seed;
    }

    public long randomLong() {
        return this.rng() & 0xFFFFFFFF00000000L | this.rng() >>> 32;
    }

    public int randomInt() {
        return (int)(this.rng() >>> 32);
    }

    public int randomInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BAD_BOUND);
        }
        return (int)(this.rng() >>> 33) % bound;
    }

    public short randomShort() {
        return (short)(this.rng() >>> 48);
    }

    public byte randomByte() {
        return (byte)(this.rng() >>> 56);
    }

    public byte randomNibble() {
        return (byte)(this.rng() >>> 60);
    }

    public boolean randomBool() {
        return this.rng() >>> 63 == 1L;
    }

    public double randomDouble() {
        return (double)(this.rng() >>> 11) * (double)1.110223E-16f;
    }

    public float randomFloat() {
        return (float)(this.rng() >>> 40) / 1.6777216E7f;
    }

    public double randomGaussian() {
        double nextNr;
        double currNr;
        double s;
        if (this.haveNextGaussian) {
            this.haveNextGaussian = false;
            return this.nextGaussian;
        }
        while ((s = (currNr = 2.0 * this.randomDouble() - 1.0) * currNr + (nextNr = 2.0 * this.randomDouble() - 1.0) * nextNr) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextGaussian = nextNr * multiplier;
        this.haveNextGaussian = true;
        return currNr * multiplier;
    }
}

