/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;

public final class ModelBoxBuilder<T extends ModelRenderer> {
    private T box;

    public static ModelBoxBuilder<ModelRenderer> newBuilder(ModelBase model) {
        return ModelBoxBuilder.newBuilder(model, null, ModelRenderer.class);
    }

    public static ModelBoxBuilder<ModelRenderer> newBuilder(ModelBase model, String name) {
        return ModelBoxBuilder.newBuilder(model, name, ModelRenderer.class);
    }

    public static <T extends ModelRenderer> ModelBoxBuilder<T> newBuilder(ModelBase model, Class<T> boxClass) {
        return ModelBoxBuilder.newBuilder(model, null, boxClass);
    }

    public static <T extends ModelRenderer> ModelBoxBuilder<T> newBuilder(ModelBase model, String name, Class<T> boxClass) {
        return new ModelBoxBuilder<T>(model, name, boxClass);
    }

    private ModelBoxBuilder(ModelBase model, String name, Class<T> boxClass) {
        try {
            this.box = name != null ? (ModelRenderer)boxClass.getConstructor(ModelBase.class, String.class).newInstance(model, name) : (ModelRenderer)boxClass.getConstructor(ModelBase.class).newInstance(model);
            ((ModelRenderer)this.box).field_78801_a = model.field_78090_t;
            ((ModelRenderer)this.box).field_78799_b = model.field_78089_u;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to build Model box! Check your inheritance or constructors of your ModelRenderer subclass if you've provided one!", e);
        }
    }

    public ModelBoxBuilder<T> setTexture(int x, int y, boolean mirror) {
        this.box.func_78784_a(x, y);
        ((ModelRenderer)this.box).field_78809_i = mirror;
        return this;
    }

    public ModelBoxBuilder<T> setTexture(int x, int y, boolean mirror, float width, float height) {
        ((ModelRenderer)this.box).field_78801_a = width;
        ((ModelRenderer)this.box).field_78799_b = height;
        this.box.func_78784_a(x, y);
        ((ModelRenderer)this.box).field_78809_i = mirror;
        return this;
    }

    public ModelBoxBuilder<T> setLocation(float pointX, float pointY, float pointZ) {
        ((ModelRenderer)this.box).field_78800_c = pointX;
        ((ModelRenderer)this.box).field_78797_d = pointY;
        ((ModelRenderer)this.box).field_78798_e = pointZ;
        return this;
    }

    public ModelBoxBuilder<T> setRotation(float angleX, float angleY, float angleZ) {
        ((ModelRenderer)this.box).field_78795_f = angleX;
        ((ModelRenderer)this.box).field_78796_g = angleY;
        ((ModelRenderer)this.box).field_78808_h = angleZ;
        return this;
    }

    public T getBox(float xOffset, float yOffset, float zOffset, int xSize, int ySize, int zSize, float scale) {
        this.box.func_78790_a(xOffset, yOffset, zOffset, xSize, ySize, zSize, scale);
        return this.box;
    }
}

