/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import de.sanandrew.mods.sanlib.lib.client.ModelBoxBuilder;
import de.sanandrew.mods.sanlib.lib.client.ModelJsonHandler;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.sanplayermodel.SanPlayerModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ModelJsonLoader<T extends ModelBase, U extends ModelJson>
implements ISelectiveResourceReloadListener,
IResourceType {
    private T modelBase;
    private ModelRenderer[] mainBoxes;
    private Map<String, ModelRenderer> nameToBoxList;
    private Map<ModelRenderer, String> boxToNameList;
    private Map<String, Class<? extends ModelRenderer>> cstBoxRenderer;
    private ResourceLocation resLoc;
    private String[] mandatNames;
    private boolean loaded;
    private Class<U> jsonClass;
    private U jsonInst;
    public static final Queue<ModelJsonLoader<?, ?>> REGISTERED_JSON_LOADERS = new ConcurrentLinkedQueue();

    public static <T extends ModelBase> ModelJsonLoader<T, ModelJson> create(T modelBase, ResourceLocation location, String ... mandatoryNames) {
        return new ModelJsonLoader<T, ModelJson>(modelBase, ModelJson.class, location, mandatoryNames);
    }

    public static <T extends ModelBase, U extends ModelJson> ModelJsonLoader<T, U> create(T modelBase, Class<U> jsonClass, ResourceLocation location, String ... mandatoryNames) {
        return new ModelJsonLoader<T, U>(modelBase, jsonClass, location, mandatoryNames);
    }

    private ModelJsonLoader(T modelBase, Class<U> jsonClass, ResourceLocation location, String[] mandatoryNames) {
        this.modelBase = modelBase;
        this.mainBoxes = new ModelRenderer[0];
        this.nameToBoxList = new HashMap<String, ModelRenderer>();
        this.boxToNameList = new HashMap<ModelRenderer, String>();
        this.cstBoxRenderer = new HashMap<String, Class<? extends ModelRenderer>>();
        this.mandatNames = (String[])mandatoryNames.clone();
        this.resLoc = location;
        this.loaded = false;
        this.jsonClass = jsonClass;
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        }
        REGISTERED_JSON_LOADERS.add(this);
    }

    public void addCustomModelRenderer(String boxName, Class<? extends ModelRenderer> rendererClass) {
        this.cstBoxRenderer.put("boxName", rendererClass);
    }

    public void unregister() {
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).field_110546_b.remove(this);
        }
        REGISTERED_JSON_LOADERS.remove(this);
    }

    private void loadJson(ResourceLocation resource, Map<String, Boolean> mandatoryChecklist) throws IOException, JsonIOException, JsonSyntaxException {
        this.loadJson(resource, true, mandatoryChecklist, new HashMap<String, ChildCube>(), new HashMap<String, ModelRenderer>());
    }

    private void loadJson(ResourceLocation resource, boolean isMain, Map<String, Boolean> mandatoryChecklist, Map<String, ChildCube> children, Map<String, ModelRenderer> mainBoxesList) throws IOException, JsonIOException, JsonSyntaxException {
        try (IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
             BufferedReader in = new BufferedReader(new InputStreamReader(res.func_110527_b()));){
            ModelJson json = (ModelJson)new Gson().fromJson((Reader)in, this.jsonClass);
            if (json.parent != null && !json.parent.isEmpty()) {
                this.loadJson(new ResourceLocation(json.parent), false, mandatoryChecklist, children, mainBoxesList);
            }
            if (json.cubes != null) {
                for (Cube cb : json.cubes) {
                    Double scaling;
                    float baseScale = ((ModelJsonHandler)this.modelBase).getBaseScale();
                    if (cb.scaling != null) {
                        scaling = MiscUtils.calcFormula(cb.scaling.replace("x", Float.toString(baseScale)));
                        if (scaling == null) {
                            scaling = baseScale;
                        }
                    } else {
                        scaling = baseScale;
                    }
                    Class<ModelRenderer> mrCls = MiscUtils.defIfNull(this.cstBoxRenderer.get(cb.boxName), ModelRenderer.class);
                    ModelRenderer box2 = ModelBoxBuilder.newBuilder(this.modelBase, cb.boxName, mrCls).setTexture(cb.textureX, cb.textureY, cb.mirror, cb.textureWidth, cb.textureHeight).setLocation(cb.rotationPointX, cb.rotationPointY, cb.rotationPointZ).setRotation(cb.rotateAngleX, cb.rotateAngleY, cb.rotateAngleZ).getBox(cb.offsetX, cb.offsetY, cb.offsetZ, cb.sizeX, cb.sizeY, cb.sizeZ, scaling.floatValue());
                    box2.field_78807_k = cb.isHidden;
                    if (cb.parentBox != null && !cb.parentBox.isEmpty()) {
                        children.put(box2.field_78802_n, new ChildCube(box2, cb.parentBox));
                    } else {
                        mainBoxesList.put(box2.field_78802_n, box2);
                    }
                    mandatoryChecklist.put(cb.boxName, true);
                }
            }
            if (json.texture != null && !json.texture.isEmpty()) {
                ((ModelJsonHandler)this.modelBase).setTexture(json.texture);
            }
            if (isMain) {
                if (mandatoryChecklist.containsValue(false)) {
                    SanPlayerModel.LOG.printf(Level.WARN, "Model %s has not all mandatory boxes! Missing %s", new Object[]{this.resLoc.toString(), String.join((CharSequence)", ", mandatoryChecklist.keySet().stream().filter(name -> (Boolean)mandatoryChecklist.get(name) == false).collect(Collectors.toList()))});
                    this.nameToBoxList.clear();
                    this.boxToNameList.clear();
                    this.mainBoxes = new ModelRenderer[0];
                    throw new IOException();
                }
                mainBoxesList.forEach((name, box) -> {
                    this.nameToBoxList.put((String)name, (ModelRenderer)box);
                    this.boxToNameList.put((ModelRenderer)box, (String)name);
                });
                children.forEach((name, child) -> {
                    this.nameToBoxList.put((String)name, ((ChildCube)child).box);
                    this.boxToNameList.put(((ChildCube)child).box, (String)name);
                });
                children.forEach((name, child) -> {
                    if (this.nameToBoxList.containsKey(((ChildCube)child).parentName)) {
                        this.nameToBoxList.get(((ChildCube)child).parentName).func_78792_a(((ChildCube)child).box);
                    } else {
                        ((ModelBase)this.modelBase).field_78092_r.stream().filter(box -> box.field_78802_n != null && box.field_78802_n.equals(((ChildCube)child).parentName)).forEach(box -> box.func_78792_a(((ChildCube)child).box));
                    }
                });
                this.mainBoxes = mainBoxesList.values().toArray(new ModelRenderer[mainBoxesList.size()]);
                this.jsonInst = json;
                this.loaded = true;
            }
        }
    }

    public void load() {
        this.mainBoxes = new ModelRenderer[0];
        this.nameToBoxList.clear();
        this.boxToNameList.clear();
        try {
            HashMap<String, Boolean> mandatoryChecklist = new HashMap<String, Boolean>();
            Arrays.asList(this.mandatNames).forEach(name -> mandatoryChecklist.put((String)name, false));
            this.loadJson(this.resLoc, mandatoryChecklist);
        }
        catch (IOException ex) {
            SanPlayerModel.LOG.log(Level.WARN, String.format("Can't load model location %s!", this.resLoc.toString()));
            this.nameToBoxList.clear();
            this.boxToNameList.clear();
            this.mainBoxes = new ModelRenderer[0];
            this.jsonInst = null;
            this.loaded = false;
        }
        catch (JsonIOException | JsonSyntaxException ex) {
            SanPlayerModel.LOG.log(Level.WARN, String.format("Can't load model location %s!", this.resLoc.toString()), ex);
            this.nameToBoxList.clear();
            this.boxToNameList.clear();
            this.mainBoxes = new ModelRenderer[0];
            this.jsonInst = null;
            this.loaded = false;
        }
    }

    public ModelRenderer getBox(String name) {
        return this.nameToBoxList.get(name);
    }

    public String getName(ModelRenderer box) {
        return this.boxToNameList.get(box);
    }

    public ModelRenderer[] getMainBoxes() {
        return this.mainBoxes;
    }

    public U getModelJsonInstance() {
        return this.jsonInst;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test(this) || resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            ((ModelJsonHandler)this.modelBase).onReload(resourceManager, this);
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private static class Cube {
        public String boxName;
        public int sizeX;
        public int sizeY;
        public int sizeZ;
        public int textureX;
        public int textureY;
        public float textureWidth = 64.0f;
        public float textureHeight = 32.0f;
        public boolean mirror = false;
        public float rotationPointX = 0.0f;
        public float rotationPointY = 0.0f;
        public float rotationPointZ = 0.0f;
        public float rotateAngleX = 0.0f;
        public float rotateAngleY = 0.0f;
        public float rotateAngleZ = 0.0f;
        public boolean isHidden = false;
        public float offsetX;
        public float offsetY;
        public float offsetZ;
        public String parentBox;
        public String scaling;

        private Cube() {
        }
    }

    private static class ChildCube {
        private final ModelRenderer box;
        private final String parentName;

        private ChildCube(ModelRenderer box, String parentName) {
            this.box = box;
            this.parentName = parentName;
        }
    }

    public static class ModelJson {
        public String texture;
        public String parent;
        protected Cube[] cubes;
    }
}

