/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client;

import de.sanandrew.mods.sanlib.SLibConfig;
import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.client.ClientTickHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.ARBShaderObjects;

@SideOnly(value=Side.CLIENT)
public final class ShaderHelper {
    public static void useShader(int shader, Consumer<Integer> callback) {
        if (!ShaderHelper.areShadersEnabled()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)time, (int)ClientTickHandler.ticksInGame);
            if (callback != null) {
                callback.accept(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    public static boolean areShadersEnabled() {
        return OpenGlHelper.field_148824_g && SLibConfig.Client.useShaders;
    }

    public static int getSecondaryTextureUnit() {
        return SLibConfig.Client.glSecondaryTextureUnit;
    }

    public static int createProgram(ResourceLocation vert, ResourceLocation frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            SanLib.LOG.log(Level.ERROR, ShaderHelper.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            SanLib.LOG.log(Level.ERROR, ShaderHelper.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(ResourceLocation file, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFileAsString(file));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (IOException | NullPointerException e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            SanLib.LOG.log(Level.ERROR, "Cannot create Shader!", (Throwable)e);
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    private static String readFileAsString(ResourceLocation file) throws IOException {
        StringBuilder source = new StringBuilder();
        try (IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
             InputStream in = res.func_110527_b();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                source.append(line).append('\n');
            }
        }
        catch (NullPointerException ex) {
            return "";
        }
        return source.toString();
    }
}

