/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.gui;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Button;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ContainerName;
import de.sanandrew.mods.sanlib.lib.client.gui.element.DynamicText;
import de.sanandrew.mods.sanlib.lib.client.gui.element.GroupBox;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Item;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Rectangle;
import de.sanandrew.mods.sanlib.lib.client.gui.element.RedstoneFluxBar;
import de.sanandrew.mods.sanlib.lib.client.gui.element.RedstoneFluxText;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ScrollArea;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.TextField;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Tooltip;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import org.apache.logging.log4j.Level;

public class GuiDefinition
implements ISelectiveResourceReloadListener {
    public static final Map<ResourceLocation, Supplier<IGuiElement>> TYPES = new HashMap<ResourceLocation, Supplier<IGuiElement>>();
    public int width;
    public int height;
    private ResourceLocation texture;
    GuiElementInst[] foregroundElements;
    GuiElementInst[] backgroundElements;
    EnumMap<IGuiElement.PriorityTarget, GuiElementInst[]> prioritizedFgElements = new EnumMap(IGuiElement.PriorityTarget.class);
    EnumMap<IGuiElement.PriorityTarget, GuiElementInst[]> prioritizedBgElements = new EnumMap(IGuiElement.PriorityTarget.class);
    private final Map<String, GuiElementInst> idToElementMap = new HashMap<String, GuiElementInst>();
    private final ResourceLocation data;
    private final Consumer<JsonObject> loadProcessor;

    private GuiDefinition(ResourceLocation data, Consumer<JsonObject> loadProcessor) throws IOException {
        this.data = data;
        this.loadProcessor = loadProcessor;
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        this.reloadDefinition();
    }

    public static GuiDefinition getNewDefinition(ResourceLocation data) throws IOException {
        return new GuiDefinition(data, null);
    }

    public static GuiDefinition getNewDefinition(ResourceLocation data, Consumer<JsonObject> loadProcessor) throws IOException {
        return new GuiDefinition(data, loadProcessor);
    }

    private void reloadDefinition() throws IOException {
        this.idToElementMap.clear();
        ArrayList<GuiElementInst> bgElem = new ArrayList<GuiElementInst>();
        ArrayList<GuiElementInst> fgElem = new ArrayList<GuiElementInst>();
        this.loadFile(this.data, bgElem, fgElem);
        this.backgroundElements = bgElem.toArray(new GuiElementInst[0]);
        this.foregroundElements = fgElem.toArray(new GuiElementInst[0]);
        Arrays.stream(this.backgroundElements).forEach(this::initElement);
        Arrays.stream(this.foregroundElements).forEach(this::initElement);
        for (IGuiElement.PriorityTarget tgt : IGuiElement.PriorityTarget.VALUES) {
            this.prioritizedBgElements.put(tgt, GuiDefinition.getPrioritizedElements(this.backgroundElements, tgt));
            this.prioritizedFgElements.put(tgt, GuiDefinition.getPrioritizedElements(this.foregroundElements, tgt));
        }
    }

    private void loadFile(ResourceLocation location, List<GuiElementInst> bgElem, List<GuiElementInst> fgElem) throws IOException {
        try (IResource r = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
             InputStreamReader reader = new InputStreamReader(r.func_110527_b(), StandardCharsets.UTF_8);){
            JsonElement json = new JsonParser().parse((Reader)reader);
            if (!json.isJsonObject()) {
                throw new IOException(String.format("Cannot read JSON of data-driven GUI %s as it isn't an object", this.data));
            }
            JsonObject jObj = json.getAsJsonObject();
            if (jObj.has("parent")) {
                this.loadFile(new ResourceLocation(JsonUtils.getStringVal(jObj.get("parent"))), bgElem, fgElem);
            }
            this.width = JsonUtils.getIntVal(jObj.get("width"), this.width);
            this.height = JsonUtils.getIntVal(jObj.get("height"), this.height);
            if (jObj.has("texture")) {
                this.texture = new ResourceLocation(jObj.get("texture").getAsString());
            }
            bgElem.addAll(Arrays.asList((Object[])JsonUtils.GSON.fromJson(jObj.get("backgroundElements"), GuiElementInst[].class)));
            fgElem.addAll(Arrays.asList((Object[])JsonUtils.GSON.fromJson(jObj.get("foregroundElements"), GuiElementInst[].class)));
            if (this.loadProcessor != null) {
                this.loadProcessor.accept(jObj);
            }
        }
    }

    public void initElement(GuiElementInst e) {
        if (e != null) {
            if (!Strings.isNullOrEmpty((String)e.id)) {
                this.idToElementMap.put(e.id, e);
            }
            if (e.data == null) {
                e.data = new JsonObject();
            }
        }
    }

    public ResourceLocation getTexture(JsonElement texture) {
        if (texture != null) {
            return new ResourceLocation(texture.getAsString());
        }
        return this.texture;
    }

    public void initGui(IGui gui) {
        Consumer<GuiElementInst> f = e -> {
            e.firstRenderUpdate = false;
            e.get().bakeData(gui, e.data, (GuiElementInst)e);
        };
        Arrays.stream(this.backgroundElements).forEach(f);
        Arrays.stream(this.foregroundElements).forEach(f);
    }

    public static void renderElement(IGui gui, int mouseX, int mouseY, float partialTicks, GuiElementInst e) {
        GuiDefinition.renderElement(gui, e.pos[0], e.pos[1], mouseX, mouseY, partialTicks, e);
    }

    public static void renderElement(IGui gui, int x, int y, int mouseX, int mouseY, float partialTicks, GuiElementInst e) {
        IGuiElement ie = e.get();
        if (e.isVisible()) {
            if (!e.firstRenderUpdate || ie.forceRenderUpdate(gui)) {
                e.firstRenderUpdate = true;
                ie.update(gui, e.data);
            }
            switch (e.getAlignmentH()) {
                case RIGHT: {
                    x -= ie.getWidth();
                    break;
                }
                case CENTER: {
                    x -= ie.getWidth() / 2;
                }
            }
            switch (e.getAlignmentV()) {
                case BOTTOM: {
                    y -= ie.getHeight();
                    break;
                }
                case CENTER: {
                    y -= ie.getHeight() / 2;
                }
            }
            ie.render(gui, partialTicks, x, y, mouseX, mouseY, e.data);
        }
    }

    public void drawBackground(IGui gui, int mouseX, int mouseY, float partialTicks) {
        Arrays.stream(this.backgroundElements).forEach(e -> GuiDefinition.renderElement(gui, mouseX, mouseY, partialTicks, e));
    }

    public void drawForeground(IGui gui, int mouseX, int mouseY, float partialTicks) {
        Arrays.stream(this.foregroundElements).forEach(e -> GuiDefinition.renderElement(gui, mouseX, mouseY, partialTicks, e));
    }

    private static GuiElementInst[] getPrioritizedElements(GuiElementInst[] elements, IGuiElement.PriorityTarget target) {
        return (GuiElementInst[])Arrays.stream(elements).sorted(Comparator.comparing(e -> GuiDefinition.getPriority(e, target))).toArray(GuiElementInst[]::new);
    }

    public void handleMouseInput(IGui gui) throws IOException {
        for (GuiElementInst e : this.prioritizedBgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible()) continue;
            e.get().handleMouseInput(gui);
        }
        for (GuiElementInst e : this.prioritizedFgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible()) continue;
            e.get().handleMouseInput(gui);
        }
    }

    public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        for (GuiElementInst e : this.prioritizedBgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible() || !e.get().mouseClicked(gui, mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        for (GuiElementInst e : this.prioritizedFgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible() || !e.get().mouseClicked(gui, mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public void mouseReleased(IGui gui, int mouseX, int mouseY, int state) {
        for (GuiElementInst e : this.prioritizedBgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible()) continue;
            e.get().mouseReleased(gui, mouseX, mouseY, state);
        }
        for (GuiElementInst e : this.prioritizedFgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible()) continue;
            e.get().mouseReleased(gui, mouseX, mouseY, state);
        }
    }

    public void mouseClickMove(IGui gui, int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (GuiElementInst e : this.prioritizedBgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible()) continue;
            e.get().mouseClickMove(gui, mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
        for (GuiElementInst e : this.prioritizedFgElements.get((Object)IGuiElement.PriorityTarget.MOUSE_INPUT)) {
            if (!e.isVisible()) continue;
            e.get().mouseClickMove(gui, mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    public boolean keyTyped(IGui gui, char typedChar, int keyCode) throws IOException {
        for (GuiElementInst e : this.prioritizedBgElements.get((Object)IGuiElement.PriorityTarget.KEY_INPUT)) {
            if (!e.isVisible() || !e.get().keyTyped(gui, typedChar, keyCode)) continue;
            return true;
        }
        for (GuiElementInst e : this.prioritizedFgElements.get((Object)IGuiElement.PriorityTarget.KEY_INPUT)) {
            if (!e.isVisible() || !e.get().keyTyped(gui, typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public void guiClosed(IGui gui) {
        for (GuiElementInst e : this.backgroundElements) {
            if (!e.isVisible()) continue;
            e.get().guiClosed(gui);
        }
        for (GuiElementInst e : this.foregroundElements) {
            if (!e.isVisible()) continue;
            e.get().guiClosed(gui);
        }
    }

    private static EventPriority getPriority(GuiElementInst elem, IGuiElement.PriorityTarget target) {
        IGuiElement.Priority[] priorities;
        IGuiElement.Priorities pAnnotation = elem.getClass().getAnnotation(IGuiElement.Priorities.class);
        if (pAnnotation == null) {
            return EventPriority.NORMAL;
        }
        for (IGuiElement.Priority priority : priorities = pAnnotation.value()) {
            if (priority.target() != target) continue;
            return priority.value();
        }
        return EventPriority.NORMAL;
    }

    public GuiElementInst getElementById(String id) {
        return this.idToElementMap.get(id);
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        try {
            this.reloadDefinition();
        }
        catch (IOException ex) {
            SanLib.LOG.log(Level.ERROR, "Error whilst reloading GUI definition", (Throwable)ex);
        }
    }

    public void update(IGui gui) {
        Consumer<GuiElementInst> f = e -> {
            if (e.isVisible()) {
                e.firstRenderUpdate = true;
                e.get().update(gui, e.data);
            }
        };
        Arrays.stream(this.backgroundElements).forEach(f);
        Arrays.stream(this.foregroundElements).forEach(f);
    }

    static {
        TYPES.put(Text.ID, Text::new);
        TYPES.put(Texture.ID, Texture::new);
        TYPES.put(Rectangle.ID, Rectangle::new);
        TYPES.put(ScrollArea.ID, ScrollArea::new);
        TYPES.put(ContainerName.ID, ContainerName::new);
        TYPES.put(Tooltip.ID, Tooltip::new);
        TYPES.put(RedstoneFluxBar.ID, RedstoneFluxBar::new);
        TYPES.put(RedstoneFluxText.ID, RedstoneFluxText::new);
        TYPES.put(DynamicText.ID, DynamicText::new);
        TYPES.put(Button.ID, Button::new);
        TYPES.put(TextField.ID, TextField::new);
        TYPES.put(Item.ID, Item::new);
        TYPES.put(GroupBox.ID, GroupBox::new);
    }
}

