/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.gui;

import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraftforge.fml.common.eventhandler.EventPriority;

public interface IGuiElement {
    public void bakeData(IGui var1, JsonObject var2, GuiElementInst var3);

    default public void update(IGui gui, JsonObject data) {
    }

    public void render(IGui var1, float var2, int var3, int var4, int var5, int var6, JsonObject var7);

    default public void handleMouseInput(IGui gui) throws IOException {
    }

    default public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        return false;
    }

    default public void mouseReleased(IGui gui, int mouseX, int mouseY, int state) {
    }

    default public void mouseClickMove(IGui gui, int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    default public void guiClosed(IGui gui) {
    }

    public int getWidth();

    public int getHeight();

    default public boolean isVisible() {
        return true;
    }

    default public boolean keyTyped(IGui gui, char typedChar, int keyCode) throws IOException {
        return false;
    }

    default public boolean forceRenderUpdate(IGui gui) {
        return false;
    }

    public static boolean isHovering(IGui gui, int x, int y, int mouseX, int mouseY, int width, int height) {
        return (mouseX -= gui.getScreenPosX()) >= x && mouseX < x + width && (mouseY -= gui.getScreenPosY()) >= y && mouseY < y + height;
    }

    public static enum PriorityTarget {
        MOUSE_INPUT,
        KEY_INPUT;

        public static final PriorityTarget[] VALUES;

        static {
            VALUES = PriorityTarget.values();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=Priorities.class)
    @Target(value={ElementType.TYPE})
    public static @interface Priority {
        public EventPriority value();

        public PriorityTarget target();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Priorities {
        public Priority[] value();
    }
}

