/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.gui.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ElementParent;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.Range;

public class Button
extends ElementParent<String> {
    public static final ResourceLocation ID = new ResourceLocation("button");
    public static final String LABEL = "label";
    public ResourceLocation texture;
    public int[] size;
    public int[] textureSize;
    public int[] uvEnabled;
    public int[] uvHover;
    public int[] uvDisabled;
    public int[] uvSize;
    public int centralTextureWidth;
    public int centralTextureHeight;
    public int buttonFunction;
    protected GuiButton buttonDelegate;
    protected int currMouseX;
    protected int currMouseY;
    protected boolean isCurrHovering;

    @Override
    public void buildChildren(IGui gui, JsonObject data, Map<String, GuiElementInst> listToBuild) {
        JsonElement lbl = data.get(LABEL);
        GuiElementInst lblInst = null;
        if (lbl != null) {
            lblInst = ((GuiElementInst)JsonUtils.GSON.fromJson(lbl, GuiElementInst.class)).initialize(gui);
        } else {
            lbl = data.get("labelText");
            if (lbl != null) {
                int[] lblPos = new int[]{this.size[0] / 2, this.size[1] / 2};
                if (lbl.isJsonPrimitive()) {
                    JsonObject colors = new JsonObject();
                    colors.addProperty("default", "0xFFFFFFFF");
                    colors.addProperty("hover", "0xFFFFFFA0");
                    colors.addProperty("disabled", "0xFFA0A0A0");
                    JsonObject lblData = new JsonObject();
                    JsonUtils.addJsonProperty(lblData, "text", lbl.getAsString());
                    lblData.add("color", (JsonElement)colors);
                    lblInst = new GuiElementInst(lblPos, new Text(), lblData).initialize(gui);
                } else {
                    lblInst = new GuiElementInst(lblPos, new Text(), lbl.getAsJsonObject()).initialize(gui);
                }
            }
        }
        if (lblInst != null) {
            lblInst.alignment = JsonUtils.getStringArray(data.get("alignLabel"), new String[]{"center", "center"});
            listToBuild.put(LABEL, lblInst);
        }
    }

    @Override
    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.texture = JsonUtils.getBoolVal(data.get("useVanillaTexture"), true) ? new ResourceLocation(JsonUtils.getStringVal(data.get("texture"), "textures/gui/widgets.png")) : gui.getDefinition().getTexture(data.get("texture"));
        this.size = JsonUtils.getIntArray(data.get("size"), (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.uvSize = JsonUtils.getIntArray(data.get("uvSize"), new int[]{200, 20}, (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.uvEnabled = JsonUtils.getIntArray(data.get("uvEnabled"), new int[]{0, 66}, (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.uvHover = JsonUtils.getIntArray(data.get("uvHover"), new int[]{this.uvEnabled[0], this.uvEnabled[1] + this.uvSize[1]}, (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.uvDisabled = JsonUtils.getIntArray(data.get("uvDisabled"), new int[]{this.uvEnabled[0], this.uvEnabled[1] - this.uvSize[1]}, (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.centralTextureWidth = JsonUtils.getIntVal(data.get("centralTextureWidth"), 190);
        this.centralTextureHeight = JsonUtils.getIntVal(data.get("centralTextureHeight"), 14);
        this.buttonFunction = JsonUtils.getIntVal(data.get("buttonFunction"));
        this.textureSize = JsonUtils.getIntArray(data.get("textureSize"), new int[]{256, 256}, (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.buttonDelegate = new GuiButton(this.buttonFunction, 0, 0, "");
        super.bakeData(gui, data, inst);
    }

    @Override
    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        this.currMouseX = mouseX;
        this.currMouseY = mouseY;
        this.isCurrHovering = this.isHovering(gui, x, y, mouseX, mouseY);
        boolean isEnabled = this.isEnabled();
        gui.get().field_146297_k.field_71446_o.func_110577_a(this.texture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        this.drawRect(isEnabled, this.isCurrHovering);
        GlStateManager.func_179121_F();
        GuiElementInst label = this.getChild(LABEL);
        if (label != null) {
            IGuiElement e = label.get();
            if (e instanceof Text) {
                ((Text)e).setColor(isEnabled ? (this.isCurrHovering ? "hover" : "default") : "disabled");
            }
            GuiDefinition.renderElement(gui, x + label.pos[0], y + label.pos[1], mouseX, mouseY, partTicks, label);
        }
    }

    public boolean isHovering(IGui gui, int x, int y, int mouseX, int mouseY) {
        return IGuiElement.isHovering(gui, x, y, mouseX, mouseY, this.size[0], this.size[1]);
    }

    @Override
    public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.isEnabled() && this.isCurrHovering) {
            ArrayList<GuiButton> btnList;
            GuiButton btn;
            GuiScreen gs = gui.get();
            GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre(gs, btn = this.buttonDelegate, btnList = new ArrayList<GuiButton>(Collections.singletonList(this.buttonDelegate)));
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return true;
            }
            btn = event.getButton();
            btn.func_146113_a(gs.field_146297_k.func_147118_V());
            this.performAction(gui, btn.field_146127_k);
            if (gs.equals(gs.field_146297_k.field_71462_r)) {
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post(gs, btn, btnList));
            }
            return true;
        }
        return super.mouseClicked(gui, mouseX, mouseY, mouseButton);
    }

    public void performAction(IGui gui, int id) {
        gui.performAction(this, id);
    }

    protected void drawRect(boolean enabled, boolean hovered) {
        int[] uv;
        int[] nArray = enabled ? (hovered ? this.uvHover : this.uvEnabled) : (uv = this.uvDisabled);
        if (this.uvSize[0] == this.size[0] && this.uvSize[1] == this.size[1]) {
            Gui.func_146110_a((int)0, (int)0, (float)uv[0], (float)uv[1], (int)this.size[0], (int)this.size[1], (float)this.textureSize[0], (float)this.textureSize[1]);
        } else {
            int cornerWidth = (this.uvSize[0] - this.centralTextureWidth) / 2;
            int cornerHeight = (this.uvSize[1] - this.centralTextureHeight) / 2;
            Gui.func_146110_a((int)0, (int)0, (float)uv[0], (float)uv[1], (int)cornerWidth, (int)cornerHeight, (float)this.textureSize[0], (float)this.textureSize[1]);
            Gui.func_146110_a((int)0, (int)(this.size[1] - cornerHeight), (float)uv[0], (float)(uv[1] + this.uvSize[1] - cornerHeight), (int)cornerWidth, (int)cornerHeight, (float)this.textureSize[0], (float)this.textureSize[1]);
            Gui.func_146110_a((int)(this.size[0] - cornerWidth), (int)0, (float)(uv[0] + this.uvSize[0] - cornerWidth), (float)uv[1], (int)cornerWidth, (int)cornerHeight, (float)this.textureSize[0], (float)this.textureSize[1]);
            Gui.func_146110_a((int)(this.size[0] - cornerWidth), (int)(this.size[1] - cornerHeight), (float)(uv[0] + this.uvSize[0] - cornerWidth), (float)(uv[1] + this.uvSize[1] - cornerHeight), (int)cornerWidth, (int)cornerHeight, (float)this.textureSize[0], (float)this.textureSize[1]);
            Button.drawTiledTexture(0, cornerHeight, uv[0], uv[1] + cornerHeight, cornerWidth, this.uvSize[1] - cornerHeight * 2, cornerWidth, this.size[1] - cornerHeight * 2, this.textureSize[0], this.textureSize[1]);
            Button.drawTiledTexture(cornerWidth, 0, uv[0] + cornerWidth, uv[1], this.uvSize[0] - cornerWidth * 2, cornerHeight, this.size[0] - cornerWidth * 2, cornerHeight, this.textureSize[0], this.textureSize[1]);
            Button.drawTiledTexture(this.size[0] - cornerWidth, cornerHeight, uv[0] + this.uvSize[0] - cornerWidth, uv[1] + cornerHeight, cornerWidth, this.uvSize[1] - cornerHeight * 2, cornerWidth, this.size[1] - cornerHeight * 2, this.textureSize[0], this.textureSize[1]);
            Button.drawTiledTexture(cornerWidth, this.size[1] - cornerHeight, uv[0] + cornerWidth, uv[1] + this.uvSize[1] - cornerHeight, this.uvSize[0] - cornerWidth * 2, cornerHeight, this.size[0] - cornerWidth * 2, cornerHeight, this.textureSize[0], this.textureSize[1]);
            Button.drawTiledTexture(cornerWidth, cornerHeight, uv[0] + cornerWidth, uv[1] + cornerHeight, this.uvSize[0] - cornerWidth * 2, this.uvSize[1] - cornerHeight * 2, this.size[0] - cornerWidth * 2, this.size[1] - cornerHeight * 2, this.textureSize[0], this.textureSize[1]);
        }
    }

    protected static void drawTiledTexture(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, int sheetWidth, int sheetHeight) {
        int txWidth = width;
        int txHeight = height;
        int uvX = Math.min(uWidth, width);
        int uvY = Math.min(vHeight, height);
        while (uvX > 0) {
            while (uvY > 0) {
                Gui.func_146110_a((int)(x + txWidth - width), (int)(y + txHeight - height), (float)u, (float)v, (int)uvX, (int)uvY, (float)sheetWidth, (float)sheetHeight);
                uvY = Math.min(vHeight, height -= vHeight);
            }
            height = txHeight;
            uvY = Math.min(vHeight, height);
            uvX = Math.min(uWidth, width -= uWidth);
        }
    }

    @Override
    public int getWidth() {
        return this.size[0];
    }

    @Override
    public int getHeight() {
        return this.size[1];
    }

    public void setEnabled(boolean enabled) {
        this.buttonDelegate.field_146124_l = enabled;
    }

    public boolean isEnabled() {
        return this.buttonDelegate.field_146124_l;
    }
}

