/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.gui.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class Text
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("text");
    public String text;
    public int color;
    public Map<String, Integer> colors;
    public boolean shadow;
    public int wrapWidth;
    public FontRenderer fontRenderer;
    public int lineHeight;
    protected String defaultColor;
    protected int currWidth;
    protected int currHeight;
    protected GuiElementInst.Justify justify;
    private String prevTxt;
    private List<String> renderedLines = new ArrayList<String>();

    @Override
    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.justify = inst.getAlignmentH();
        this.colors = new HashMap<String, Integer>();
        this.defaultColor = null;
        if (data.has("color")) {
            JsonElement clrData = data.get("color");
            if (clrData.isJsonObject()) {
                for (Map.Entry o : clrData.getAsJsonObject().entrySet()) {
                    String key = (String)o.getKey();
                    if (key.equalsIgnoreCase("default") || this.defaultColor == null) {
                        this.defaultColor = key;
                    }
                    this.colors.put(key, MiscUtils.hexToInt(((JsonElement)o.getValue()).getAsString()));
                }
                this.color = this.colors.get(this.defaultColor);
            } else if (clrData.isJsonPrimitive()) {
                int clr = MiscUtils.hexToInt(clrData.getAsString());
                this.defaultColor = "default";
                this.colors.put(this.defaultColor, clr);
                this.color = clr;
            } else {
                this.bakeDefaultColor();
            }
        } else {
            this.bakeDefaultColor();
        }
        this.text = this.getBakedText(gui, data);
        this.shadow = JsonUtils.getBoolVal(data.get("shadow"), false);
        this.wrapWidth = JsonUtils.getIntVal(data.get("wrapWidth"), 0);
        this.lineHeight = JsonUtils.getIntVal(data.get("lineHeight"), 9);
        JsonElement cstFont = data.get("font");
        this.fontRenderer = cstFont == null ? new Font("standard").get(gui.get()) : ((Font)JsonUtils.GSON.fromJson(cstFont, Font.class)).get(gui.get());
        this.currWidth = this.getTextWidth(gui);
        int n = this.currHeight = this.wrapWidth <= 0 ? this.text.split("\n").length * this.lineHeight : this.fontRenderer.func_78271_c(this.text, this.wrapWidth).size() * this.lineHeight;
        if (this.shadow) {
            ++this.currHeight;
        }
    }

    private void bakeDefaultColor() {
        this.defaultColor = "default";
        this.colors.put(this.defaultColor, -16777216);
        this.color = -16777216;
    }

    public String getBakedText(IGui gui, JsonObject data) {
        return LangUtils.translate(JsonUtils.getStringVal(data.get("text")), new Object[0]);
    }

    public String getDynamicText(IGui gui, String originalText) {
        return originalText;
    }

    public int getTextWidth(IGui gui) {
        if (this.wrapWidth > 0) {
            if (this.justify == GuiElementInst.Justify.JUSTIFY) {
                return this.wrapWidth;
            }
            return this.fontRenderer.func_78271_c(this.getDynamicText(gui, this.text), this.wrapWidth).stream().map(s -> this.fontRenderer.func_78256_a(s)).reduce(0, Math::max, Math::max);
        }
        return Arrays.stream(this.getDynamicText(gui, this.text).split("\n")).map(s -> this.fontRenderer.func_78256_a(s)).reduce(0, Math::max, Math::max);
    }

    @Override
    public void update(IGui gui, JsonObject data) {
        this.renderedLines.clear();
        String s = this.getDynamicText(gui, this.text);
        this.currWidth = this.getTextWidth(gui);
        String[] ln = this.wrapWidth > 0 ? this.fontRenderer.func_78271_c(s, this.wrapWidth).toArray(new String[0]) : s.split("\n");
        this.currHeight = ln.length * this.lineHeight;
        this.renderedLines.addAll(Arrays.asList(ln));
    }

    @Override
    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        for (String sln : this.renderedLines) {
            this.renderLine(sln, x, y);
            y += this.lineHeight;
        }
    }

    private void renderLine(String s, int x, int y) {
        switch (this.justify) {
            case JUSTIFY: {
                if (this.wrapWidth > 0) {
                    int i;
                    String[] words = s.split("\\s");
                    float spaceDist = this.wrapWidth;
                    int[] wordWidths = new int[words.length];
                    for (i = 0; i < words.length; ++i) {
                        wordWidths[i] = this.fontRenderer.func_78256_a(words[i]);
                        spaceDist -= (float)wordWidths[i];
                    }
                    spaceDist /= (float)(words.length - 1);
                    for (i = 0; i < words.length; ++i) {
                        this.fontRenderer.func_175065_a(words[i], (float)x, (float)y, this.color, this.shadow);
                        x = (int)((float)x + ((float)wordWidths[i] + spaceDist));
                    }
                    return;
                }
            }
            case LEFT: {
                break;
            }
            case CENTER: {
                x += (this.currWidth - this.fontRenderer.func_78256_a(s)) / 2;
                break;
            }
            case RIGHT: {
                x += this.currWidth - this.fontRenderer.func_78256_a(s);
            }
        }
        this.fontRenderer.func_175065_a(s, (float)x, (float)y, this.color, this.shadow);
    }

    @Override
    public int getWidth() {
        return this.currWidth;
    }

    @Override
    public int getHeight() {
        return this.currHeight;
    }

    public void setColor(String colorId) {
        if (colorId == null || !this.colors.containsKey(colorId)) {
            colorId = this.defaultColor;
        }
        this.color = this.colors.get(colorId);
    }

    @Override
    public boolean forceRenderUpdate(IGui gui) {
        String s = this.getDynamicText(gui, this.text);
        if (!s.equals(this.prevTxt)) {
            this.prevTxt = s;
            return true;
        }
        return false;
    }

    public static final class Font {
        public String texture;
        public Boolean unicode;
        public Boolean bidirectional;
        public WeakReference<FontRenderer> frInst;

        public Font() {
        }

        public Font(String tx) {
            this.texture = tx;
        }

        public FontRenderer get(GuiScreen gui) {
            FontRenderer fr;
            if ("standard".equals(this.texture)) {
                return gui.field_146297_k.field_71466_p;
            }
            if ("galactic".equals(this.texture)) {
                return gui.field_146297_k.field_71464_q;
            }
            FontRenderer fontRenderer = fr = this.frInst == null ? null : (FontRenderer)this.frInst.get();
            if (fr == null) {
                this.frInst = new WeakReference<FontRenderer>(new FontRenderer(gui.field_146297_k.field_71474_y, new ResourceLocation(this.texture), gui.field_146297_k.field_71446_o, this.unicode != null ? this.unicode : gui.field_146297_k.field_71474_y.field_74363_ab != null && gui.field_146297_k.func_152349_b()));
                fr = (FontRenderer)Objects.requireNonNull(this.frInst.get());
                if (this.bidirectional != null) {
                    fr.func_78275_b(this.bidirectional.booleanValue());
                } else if (gui.field_146297_k.field_71474_y.field_74363_ab != null) {
                    fr.func_78275_b(gui.field_146297_k.func_135016_M().func_135044_b());
                }
            }
            return fr;
        }

        public int hashCode() {
            return Objects.hash(this.texture, this.unicode, this.bidirectional);
        }
    }
}

