/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.gui.element;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import org.apache.commons.lang3.Range;

@IGuiElement.Priority(value=EventPriority.HIGHEST, target=IGuiElement.PriorityTarget.KEY_INPUT)
public class TextField
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("textfield");
    private boolean enabled = true;
    public int[] size;
    public int color;
    public int disabledColor;
    public int placeholderColor;
    public boolean canLoseFocus;
    public boolean drawBackground;
    public boolean shadow;
    public String text;
    public String placeholderText;
    public FontRenderer fontRenderer;
    public GuiTextField textfield;

    @Override
    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.size = JsonUtils.getIntArray(data.get("size"), (Range<Integer>)Range.is((Comparable)Integer.valueOf(2)));
        this.text = JsonUtils.getStringVal(data.get("text"), "");
        this.placeholderText = JsonUtils.getStringVal(data.get("placeholderText"), "");
        this.shadow = JsonUtils.getBoolVal(data.get("shadow"), true);
        this.canLoseFocus = JsonUtils.getBoolVal(data.get("canLoseFocus"), true);
        this.drawBackground = JsonUtils.getBoolVal(data.get("drawBackground"), true);
        this.color = MiscUtils.hexToInt(JsonUtils.getStringVal(data.get("textColor"), "0xFFE0E0E0"));
        this.placeholderColor = MiscUtils.hexToInt(JsonUtils.getStringVal(data.get("placeholderColor"), "0xFF707070"));
        this.disabledColor = MiscUtils.hexToInt(JsonUtils.getStringVal(data.get("disabledTextColor"), "0xFF707070"));
        JsonElement cstFont = data.get("font");
        this.fontRenderer = cstFont == null ? new Text.Font("standard").get(gui.get()) : ((Text.Font)JsonUtils.GSON.fromJson(cstFont, Text.Font.class)).get(gui.get());
        this.textfield = new GuiTextField(0, (FontRenderer)new FontRendererTF(gui.get().field_146297_k, this.fontRenderer), 0, 0, this.size[0], this.size[1]);
        this.textfield.func_146180_a(LangUtils.translate(this.text, new Object[0]));
        this.textfield.func_146193_g(this.color);
        this.textfield.func_146204_h(this.disabledColor);
        this.textfield.func_146205_d(this.canLoseFocus);
        this.textfield.func_146185_a(this.drawBackground);
    }

    @Override
    public void update(IGui gui, JsonObject data) {
        this.textfield.func_146178_a();
    }

    @Override
    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        this.textfield.field_146209_f = x;
        this.textfield.field_146210_g = y;
        this.textfield.func_146194_f();
        if (!this.isFocused() && !Strings.isNullOrEmpty((String)this.placeholderText) && Strings.isNullOrEmpty((String)this.getText())) {
            this.fontRenderer.func_175065_a(LangUtils.translate(this.placeholderText, new Object[0]), (float)(x += this.drawBackground ? 4 : 0), (float)(y += this.drawBackground ? (this.size[1] - 8) / 2 : 0), this.placeholderColor, this.shadow);
        }
    }

    @Override
    public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) {
        return this.textfield.func_146192_a(mouseX - gui.getScreenPosX(), mouseY - gui.getScreenPosY(), mouseButton);
    }

    @Override
    public boolean keyTyped(IGui gui, char typedChar, int keyCode) {
        return this.textfield.func_146201_a(typedChar, keyCode);
    }

    public void setText(String text) {
        this.textfield.func_146180_a(text);
    }

    public String getText() {
        return this.textfield.func_146179_b();
    }

    public void setMaxStringLength(int length) {
        this.textfield.func_146203_f(length);
    }

    public int getMaxStringLength() {
        return this.textfield.func_146208_g();
    }

    public void setFocused(boolean isFocused) {
        this.textfield.func_146195_b(isFocused);
    }

    public boolean isFocused() {
        return this.textfield.func_146206_l();
    }

    public void setCursorPosition(int pos) {
        this.textfield.func_146190_e(pos);
    }

    public void setSelectionEnd(int pos) {
        this.textfield.func_146199_i(pos);
    }

    public int[] getSelectionPos() {
        return new int[]{this.textfield.func_146198_h(), this.textfield.func_146186_n()};
    }

    public String getSelectedText() {
        return this.textfield.func_146207_c();
    }

    public void insertText(String text) {
        this.textfield.func_146191_b(text);
    }

    public void setCursorPositionEnd() {
        this.textfield.func_146202_e();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.textfield.func_146184_c(enabled);
        this.enabled = enabled;
    }

    @Override
    public boolean isVisible() {
        return this.textfield.func_146176_q();
    }

    public void setValidator(Predicate<String> validator) {
        this.textfield.func_175205_a(validator::test);
    }

    public void setResponder(final Consumer<String> responder) {
        this.textfield.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, String value) {
                responder.accept(value);
            }
        });
    }

    @Override
    public int getWidth() {
        return this.textfield.func_146200_o();
    }

    @Override
    public int getHeight() {
        return this.size[1] - (this.drawBackground ? 8 : 0);
    }

    private final class FontRendererTF
    extends FontRenderer {
        private final FontRenderer fontRenderer;

        private FontRendererTF(Minecraft mc, FontRenderer orig) {
            super(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.field_71446_o, false);
            this.fontRenderer = orig;
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.fontRenderer.func_110549_a(resourceManager);
        }

        public int func_175063_a(String text, float x, float y, int color) {
            return this.func_175065_a(text, x, y, color, TextField.this.shadow);
        }

        public int func_78276_b(String text, int x, int y, int color) {
            return this.fontRenderer.func_78276_b(text, x, y, color);
        }

        public int func_175065_a(String text, float x, float y, int color, boolean dropShadow) {
            return this.fontRenderer.func_175065_a(text, x, y, color, dropShadow);
        }

        public int func_78256_a(String text) {
            return this.fontRenderer.func_78256_a(text);
        }

        public int func_78263_a(char character) {
            return this.fontRenderer.func_78263_a(character);
        }

        public String func_78269_a(String text, int width) {
            return this.fontRenderer.func_78269_a(text, width);
        }

        public String func_78262_a(String text, int width, boolean reverse) {
            return this.fontRenderer.func_78262_a(text, width, reverse);
        }

        public void func_78279_b(String str, int x, int y, int wrapWidth, int textColor) {
            this.fontRenderer.func_78279_b(str, x, y, wrapWidth, textColor);
        }

        public int func_78267_b(String str, int maxLength) {
            return this.fontRenderer.func_78267_b(str, maxLength);
        }

        public void func_78264_a(boolean unicodeFlagIn) {
            this.fontRenderer.func_78264_a(unicodeFlagIn);
        }

        public boolean func_82883_a() {
            return this.fontRenderer.func_82883_a();
        }

        public void func_78275_b(boolean bidiFlagIn) {
            this.fontRenderer.func_78275_b(bidiFlagIn);
        }

        public List<String> func_78271_c(String str, int wrapWidth) {
            return this.fontRenderer.func_78271_c(str, wrapWidth);
        }

        public boolean func_78260_a() {
            return this.fontRenderer.func_78260_a();
        }

        public int func_175064_b(char character) {
            return this.fontRenderer.func_175064_b(character);
        }
    }
}

