/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.util;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public final class ColorUtils {
    public static ColorObj getAverageColor(InputStream is) throws IOException {
        return ColorUtils.getAverageColor(is, null);
    }

    public static ColorObj getAverageColor(InputStream is, ColorObj maskClr) throws IOException {
        BufferedImage bi = ImageIO.read(is);
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        double count = 0.0;
        for (int x = 0; x < bi.getWidth(); ++x) {
            for (int y = 0; y < bi.getHeight(); ++y) {
                ColorObj color = new ColorObj(bi.getRGB(x, y));
                if (maskClr != null && color.equals(maskClr)) continue;
                red += (double)((float)color.red() * color.fAlpha());
                green += (double)((float)color.green() * color.fAlpha());
                blue += (double)((float)color.blue() * color.fAlpha());
                count += (double)color.fAlpha();
            }
        }
        int avgRed = (int)(red / count);
        int avgGreen = (int)(green / count);
        int avgBlue = (int)(blue / count);
        return new ColorObj(avgRed, avgGreen, avgBlue, 255);
    }
}

