/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.client.util;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiUtils {
    public static void glScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        int scaleFactor = 1;
        int guiScale = mc.field_71474_y.field_74335_Z;
        if (guiScale == 0) {
            guiScale = 1000;
        }
        while (scaleFactor < guiScale && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        GL11.glScissor((int)(x * scaleFactor), (int)(mc.field_71440_d - (y + height) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    public static List<?> getTooltipWithoutShift(@Nonnull ItemStack stack) {
        ByteBuffer keyDownBuffer = (ByteBuffer)ReflectionUtils.getCachedFieldValue(Keyboard.class, null, "keyDownBuffer", "keyDownBuffer");
        byte lShift = keyDownBuffer.get(42);
        byte rShift = keyDownBuffer.get(54);
        keyDownBuffer.put(42, (byte)0);
        keyDownBuffer.put(54, (byte)0);
        List tooltip = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        keyDownBuffer.put(42, lShift);
        keyDownBuffer.put(54, rShift);
        return tooltip;
    }

    public static void drawTexturedModalRect(int xPos, int yPos, float z, int u, int v, int width, int height) {
        GuiUtils.drawTexturedModalRect(xPos, yPos, z, u, v, width, height, 0.00390625f, 0.00390625f);
    }

    public static void drawTexturedModalRect(int xPos, int yPos, float z, int u, int v, int width, int height, float resScaleX, float resScaleY) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)xPos, (double)(yPos + height), (double)z).func_187315_a((double)((float)u * resScaleX), (double)((float)(v + height) * resScaleY)).func_181675_d();
        buffer.func_181662_b((double)(xPos + width), (double)(yPos + height), (double)z).func_187315_a((double)((float)(u + width) * resScaleX), (double)((float)(v + height) * resScaleY)).func_181675_d();
        buffer.func_181662_b((double)(xPos + width), (double)yPos, (double)z).func_187315_a((double)((float)(u + width) * resScaleX), (double)((float)v * resScaleY)).func_181675_d();
        buffer.func_181662_b((double)xPos, (double)yPos, (double)z).func_187315_a((double)((float)u * resScaleX), (double)((float)v * resScaleY)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRect(int x, int y, int width, int height, int color1, int color2, boolean isHorizontal) {
        ColorObj startColor = new ColorObj(color1);
        ColorObj endColor = new ColorObj(color2);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (isHorizontal) {
            GuiUtils.buildColoredQuad(bufferbuilder, x, y, width, height, startColor, endColor);
        } else {
            GuiUtils.buildColoredQuad(bufferbuilder, x, y, width, height, endColor, startColor, startColor, endColor);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void buildColoredQuad(BufferBuilder bb, int x, int y, int width, int height, ColorObj ... colors) {
        if (colors == null || colors.length < 1) {
            return;
        }
        switch (colors.length) {
            case 1: {
                colors = new ColorObj[]{colors[0], colors[0], colors[0], colors[0]};
                break;
            }
            case 2: {
                colors = new ColorObj[]{colors[0], colors[0], colors[1], colors[1]};
                break;
            }
            case 3: {
                colors = new ColorObj[]{colors[0], colors[1], colors[2], colors[2]};
            }
        }
        bb.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(colors[0].fRed(), colors[0].fGreen(), colors[0].fBlue(), colors[0].fAlpha()).func_181675_d();
        bb.func_181662_b((double)x, (double)y, 0.0).func_181666_a(colors[1].fRed(), colors[1].fGreen(), colors[1].fBlue(), colors[1].fAlpha()).func_181675_d();
        bb.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(colors[2].fRed(), colors[2].fGreen(), colors[2].fBlue(), colors[2].fAlpha()).func_181675_d();
        bb.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(colors[3].fRed(), colors[3].fGreen(), colors[3].fBlue(), colors[3].fAlpha()).func_181675_d();
    }
}

