/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.power;

import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class EnergyHelper {
    private static final boolean COFH_EXISTS = ReflectionUtils.doesClassExist("cofh.redstobeflux.api.IEnergyHandler");
    private static final boolean TESLA_EXISTS = ReflectionUtils.doesClassExist("net.darkhax.tesla.capability.TeslaCapabilities");

    public static boolean canConnectEnergy(TileEntity te, EnumFacing facing) {
        IEnergyStorage stg;
        if (COFH_EXISTS && te instanceof IEnergyConnection) {
            return ((IEnergyConnection)te).canConnectEnergy(facing);
        }
        if (TESLA_EXISTS) {
            if (te.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, facing) != null) {
                return true;
            }
            if (te.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, facing) != null) {
                return true;
            }
        }
        return (stg = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing)) != null && (stg.canExtract() || stg.canReceive());
    }

    public static long receiveEnergy(TileEntity te, EnumFacing facing, long amount, boolean simulate) {
        ITeslaConsumer consumer;
        if (COFH_EXISTS && te instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)te).receiveEnergy(facing, (int)amount, simulate);
        }
        if (TESLA_EXISTS && (consumer = (ITeslaConsumer)te.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, facing)) != null) {
            return consumer.givePower(amount, simulate);
        }
        consumer = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing);
        if (consumer != null) {
            return consumer.receiveEnergy((int)amount, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(TileEntity te, EnumFacing facing, long amount, boolean simulate) {
        ITeslaProducer producer;
        if (COFH_EXISTS && te instanceof IEnergyProvider) {
            return ((IEnergyProvider)te).extractEnergy(facing, (int)amount, simulate);
        }
        if (TESLA_EXISTS && (producer = (ITeslaProducer)te.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, facing)) != null) {
            return producer.takePower(amount, simulate);
        }
        IEnergyStorage provider = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing);
        if (provider != null) {
            return provider.extractEnergy((int)amount, simulate);
        }
        return 0L;
    }
}

