/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.world.World;

public final class EntityUtils {
    public static final int ATTR_ADD_VAL_TO_BASE = 0;
    public static final int ATTR_ADD_PERC_VAL_TO_SUM = 1;
    public static final int RISE_SUM_WITH_PERC_VAL = 2;

    public static Entity getEntityByUUID(World worldObj, UUID uuid) {
        return new ArrayList(worldObj.field_72996_f).stream().filter(entity -> entity.func_110124_au().equals(uuid)).findFirst().orElse(null);
    }

    public static <T extends Entity> List<T> getPassengersOfClass(Entity e, Class<T> psgClass) {
        return e.func_184188_bt().stream().filter(psgClass::isInstance).map(entity -> entity).collect(Collectors.toList());
    }

    public static <T extends EntityAIBase> List<T> getAisFromTaskList(Set<EntityAITasks.EntityAITaskEntry> taskList, Class<T> cls) {
        return taskList.stream().filter(task -> cls.equals(task.field_75733_a.getClass())).map(task -> task.field_75733_a).collect(Collectors.toList());
    }

    public static boolean tryApplyModifier(EntityLivingBase e, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance attrib = e.func_110148_a(attribute);
        if (!attrib.func_180374_a(modifier)) {
            attrib.func_111121_a(modifier);
            return true;
        }
        return false;
    }

    public static boolean tryApplyModifier(EntityLivingBase e, String attributeName, AttributeModifier modifier) {
        IAttributeInstance attrib = e.func_110140_aT().func_111152_a(attributeName);
        if (attrib != null && !attrib.func_180374_a(modifier)) {
            attrib.func_111121_a(modifier);
            return true;
        }
        return false;
    }

    public static boolean tryRemoveModifier(EntityLivingBase e, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance attrib = e.func_110148_a(attribute);
        if (attrib.func_180374_a(modifier)) {
            attrib.func_111124_b(modifier);
            return true;
        }
        return false;
    }

    public static boolean tryRemoveModifier(EntityLivingBase e, String attributeName, AttributeModifier modifier) {
        IAttributeInstance attrib = e.func_110140_aT().func_111152_a(attributeName);
        if (attrib != null && attrib.func_180374_a(modifier)) {
            attrib.func_111124_b(modifier);
            return true;
        }
        return false;
    }
}

