/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class InventoryUtils {
    public static Tuple getSimilarStackFromInventory(@Nonnull ItemStack stack, IInventory inv, boolean checkNbt) {
        if (!ItemStackUtils.isValid(stack)) {
            return null;
        }
        if (inv == null) {
            return null;
        }
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (!ItemStackUtils.isValid(invStack) || !ItemStackUtils.areEqual(stack, invStack, checkNbt)) continue;
            return new Tuple(i, invStack);
        }
        return null;
    }

    public static boolean canStackFitInInventory(@Nonnull ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize) {
        return InventoryUtils.canStackFitInInventory(is, inv, checkNBT, maxStackSize, 0, inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0));
    }

    public static boolean canStackFitInInventory(@Nonnull ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize, int begin, int end) {
        ItemStack stack = is.func_77946_l();
        for (int i = begin; i < end; ++i) {
            int stackCnt;
            ItemStack invIS = inv.func_70301_a(i);
            if (ItemStackUtils.areEqual(is, invIS, checkNBT)) {
                int fit = Math.min(invIS.func_77976_d(), maxStackSize) - invIS.func_190916_E();
                if (fit >= (stackCnt = stack.func_190916_E())) {
                    return true;
                }
                stack.func_190920_e(stackCnt - fit);
                continue;
            }
            if (ItemStackUtils.isValid(invIS) || !inv.func_94041_b(i, stack)) continue;
            int max = Math.min(stack.func_77976_d(), maxStackSize);
            stackCnt = stack.func_190916_E();
            if (stackCnt - max <= 0) {
                return true;
            }
            stack.func_190920_e(stackCnt - max);
        }
        return false;
    }

    public static ItemStack addStackToInventory(@Nonnull ItemStack is, IInventory inv) {
        return InventoryUtils.addStackToInventory(is, inv, true, inv.func_70297_j_(), 0, inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0));
    }

    public static ItemStack addStackToInventory(@Nonnull ItemStack is, IInventory inv, boolean checkNBT) {
        return InventoryUtils.addStackToInventory(is, inv, checkNBT, inv.func_70297_j_(), 0, inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0));
    }

    public static ItemStack addStackToInventory(@Nonnull ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize) {
        return InventoryUtils.addStackToInventory(is, inv, checkNBT, maxStackSize, 0, inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0));
    }

    @Nonnull
    public static ItemStack addStackToInventory(@Nonnull ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize, int begin, int end) {
        for (int i = begin; i < end && ItemStackUtils.isValid(is); ++i) {
            int rest;
            ItemStack invIS = inv.func_70301_a(i);
            if (ItemStackUtils.areEqual(is, invIS, checkNBT)) {
                int maxStack;
                rest = is.func_190916_E() + invIS.func_190916_E();
                if (rest <= (maxStack = Math.min(invIS.func_77976_d(), maxStackSize))) {
                    invIS.func_190920_e(rest);
                    inv.func_70299_a(i, invIS.func_77946_l());
                    is = ItemStackUtils.getEmpty();
                    break;
                }
                int rest1 = rest - maxStack;
                invIS.func_190920_e(maxStack);
                inv.func_70299_a(i, invIS.func_77946_l());
                is.func_190920_e(rest1);
                continue;
            }
            if (ItemStackUtils.isValid(invIS) || !inv.func_94041_b(i, is)) continue;
            if (is.func_190916_E() <= maxStackSize) {
                inv.func_70299_a(i, is.func_77946_l());
                is = ItemStackUtils.getEmpty();
                break;
            }
            rest = is.func_190916_E() - maxStackSize;
            is.func_190920_e(maxStackSize);
            inv.func_70299_a(i, is.func_77946_l());
            is.func_190920_e(rest);
        }
        return is;
    }

    @Nonnull
    public static ItemStack addStackToCapability(@Nonnull ItemStack is, ICapabilityProvider provider, EnumFacing facing, boolean simulate) {
        return InventoryUtils.addStackToCapability(is, provider, facing, simulate, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
    }

    @Nonnull
    public static ItemStack addStackToCapability(@Nonnull ItemStack is, ICapabilityProvider provider, EnumFacing facing, boolean simulate, int maxStackSize) {
        return InventoryUtils.addStackToCapability(is, provider, facing, simulate, maxStackSize, 0, Integer.MAX_VALUE);
    }

    @Nonnull
    public static ItemStack addStackToCapability(@Nonnull ItemStack is, ICapabilityProvider provider, EnumFacing facing, boolean simulate, int maxStackSize, int begin, int end) {
        if (ItemStackUtils.isValid(is) && provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            IItemHandler handler = (IItemHandler)Objects.requireNonNull(provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            maxStackSize = Math.min(maxStackSize, is.func_190916_E());
            end = Math.min(end, handler.getSlots());
            for (int i = begin; i < end; ++i) {
                ItemStack remain = is.func_77946_l();
                remain.func_190920_e(maxStackSize);
                remain = handler.insertItem(i, remain, simulate);
                is.func_190920_e(is.func_190916_E() - maxStackSize + (ItemStackUtils.isValid(remain) ? remain.func_190916_E() : 0));
                maxStackSize = Math.min(maxStackSize, is.func_190916_E());
                if (is.func_190916_E() > 0) continue;
                return ItemStackUtils.getEmpty();
            }
        }
        return is;
    }

    public static boolean mergeItemStack(Container container, @Nonnull ItemStack stack, int beginSlot, int endSlot, boolean reverse) {
        Slot slot;
        boolean slotChanged = false;
        int start = beginSlot;
        if (reverse) {
            start = endSlot - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!reverse && start < endSlot || reverse && start >= beginSlot)) {
                slot = (Slot)container.field_75151_b.get(start);
                ItemStack slotStack = slot.func_75211_c();
                if (ItemStackUtils.areEqual(slotStack, stack) && slot.func_75214_a(stack)) {
                    int maxStackSize;
                    int combStackSize = slotStack.func_190916_E() + stack.func_190916_E();
                    if (combStackSize <= (maxStackSize = Math.min(stack.func_77976_d(), slot.func_178170_b(stack)))) {
                        stack.func_190920_e(0);
                        slotStack.func_190920_e(combStackSize);
                        slot.func_75218_e();
                        slotChanged = true;
                    } else if (slotStack.func_190916_E() < maxStackSize) {
                        stack.func_190918_g(maxStackSize - slotStack.func_190916_E());
                        slotStack.func_190920_e(maxStackSize);
                        slot.func_75218_e();
                        slotChanged = true;
                    }
                }
                if (reverse) {
                    --start;
                    continue;
                }
                ++start;
            }
        }
        if (stack.func_190916_E() > 0) {
            start = reverse ? endSlot - 1 : beginSlot;
            while (stack.func_190916_E() > 0 && (!reverse && start < endSlot || reverse && start >= beginSlot)) {
                slot = (Slot)container.field_75151_b.get(start);
                if (!ItemStackUtils.isValid(slot.func_75211_c()) && slot.func_75214_a(stack)) {
                    int maxStackSize = Math.min(stack.func_77976_d(), slot.func_178170_b(stack));
                    if (stack.func_190916_E() > maxStackSize) {
                        ItemStack newSlotStack = stack.func_77946_l();
                        stack.func_190918_g(maxStackSize);
                        newSlotStack.func_190920_e(maxStackSize);
                        slot.func_75215_d(newSlotStack);
                        slot.func_75218_e();
                        slotChanged = true;
                    } else {
                        slot.func_75215_d(stack.func_77946_l());
                        slot.func_75218_e();
                        stack.func_190920_e(0);
                        slotChanged = true;
                        break;
                    }
                }
                if (reverse) {
                    --start;
                    continue;
                }
                ++start;
            }
        }
        return slotChanged;
    }

    public static boolean finishTransfer(EntityPlayer player, ItemStack origStack, Slot slot, ItemStack slotStack) {
        if (slotStack.func_190916_E() == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (slotStack.func_190916_E() == origStack.func_190916_E()) {
            return true;
        }
        slot.func_190901_a(player, slotStack);
        return false;
    }

    public static void dropBlockItems(IInventory inv, World world, BlockPos pos) {
        int max = inv.func_70302_i_();
        for (int i = 0; i < max; ++i) {
            ItemStackUtils.dropBlockItem(inv.func_70301_a(i), world, pos);
        }
    }
}

