/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ItemStackUtils {
    public static boolean isValid(@Nonnull ItemStack stack) {
        return !stack.func_190926_b();
    }

    @Nonnull
    public static ItemStack getEmpty() {
        return ItemStack.field_190927_a;
    }

    public static boolean isItem(@Nonnull ItemStack stack, Item item) {
        return ItemStackUtils.isValid(stack) && stack.func_77973_b() == item;
    }

    public static boolean isBlock(@Nonnull ItemStack stack, Block block) {
        return ItemStackUtils.isValid(stack) && Block.func_149634_a((Item)stack.func_77973_b()) == block;
    }

    public static boolean areEqual(@Nonnull ItemStack is1, @Nonnull ItemStack is2) {
        return ItemStackUtils.areEqual(is1, is2, false, true, true);
    }

    public static boolean areEqual(@Nonnull ItemStack is1, @Nonnull ItemStack is2, boolean checkNbt) {
        return ItemStackUtils.areEqual(is1, is2, false, checkNbt, true);
    }

    public static boolean areEqual(@Nonnull ItemStack is1, @Nonnull ItemStack is2, boolean checkStackSize, boolean checkNbt) {
        return ItemStackUtils.areEqual(is1, is2, checkStackSize, checkNbt, true);
    }

    public static boolean areEqual(@Nonnull ItemStack is1, @Nonnull ItemStack is2, boolean checkStackSize, boolean checkNbt, boolean checkDmg) {
        return ItemStackUtils.areEqualBase(is1, is2, checkStackSize, checkDmg) && (!checkNbt || Objects.equals(is1.func_77978_p(), is2.func_77978_p()));
    }

    public static boolean areEqualNbtFit(@Nonnull ItemStack mainIS, @Nonnull ItemStack otherIS, boolean checkStackSize, boolean checkDmg) {
        return ItemStackUtils.areEqualNbtFit(mainIS, otherIS, checkStackSize, checkDmg, true);
    }

    public static boolean areEqualNbtFit(@Nonnull ItemStack mainIS, @Nonnull ItemStack otherIS, boolean checkStackSize, boolean checkDmg, boolean strict) {
        return ItemStackUtils.areEqualBase(mainIS, otherIS, checkStackSize, checkDmg) && (!otherIS.func_77942_o() || mainIS.func_77942_o() && MiscUtils.doesNbtContainOther(mainIS.func_77978_p(), otherIS.func_77978_p(), strict));
    }

    private static boolean areEqualBase(@Nonnull ItemStack is1, @Nonnull ItemStack is2, boolean checkStackSize, boolean checkDmg) {
        if (!ItemStackUtils.isValid(is1) && !ItemStackUtils.isValid(is2)) {
            return true;
        }
        if (!ItemStackUtils.isValid(is2) || !ItemStackUtils.isItem(is1, is2.func_77973_b())) {
            return false;
        }
        if (checkDmg && is1.func_77952_i() != Short.MAX_VALUE && is2.func_77952_i() != Short.MAX_VALUE && is1.func_77952_i() != is2.func_77952_i()) {
            return false;
        }
        return !checkStackSize || is1.func_190916_E() == is2.func_190916_E();
    }

    public static void writeStackToTag(@Nonnull ItemStack stack, NBTTagCompound tag, String tagName) {
        NBTTagCompound stackTag = new NBTTagCompound();
        stack.func_77955_b(stackTag);
        tag.func_74782_a(tagName, (NBTBase)stackTag);
    }

    public static boolean isStackInArray(@Nonnull ItemStack stack, ItemStack ... stacks) {
        return Arrays.stream(stacks).anyMatch(currStack -> ItemStackUtils.areEqual(stack, currStack));
    }

    public static boolean isStackInList(@Nonnull ItemStack stack, List<ItemStack> stacks) {
        return stacks.stream().anyMatch(currStack -> ItemStackUtils.areEqual(stack, currStack));
    }

    public static boolean canStack(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2, boolean consumeAll) {
        return !ItemStackUtils.isValid(stack1) || !ItemStackUtils.isValid(stack2) || stack1.func_77985_e() && ItemStackUtils.areEqual(stack1, stack2, false, true, !stack2.func_77981_g()) && (!consumeAll || stack1.func_190916_E() + stack2.func_190916_E() <= stack1.func_77976_d());
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        return ItemStackUtils.writeItemStacksToTag(Arrays.asList(items), maxQuantity, null);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity, BiConsumer<ItemStack, NBTTagCompound> callbackMethod) {
        return ItemStackUtils.writeItemStacksToTag(Arrays.asList(items), maxQuantity, callbackMethod);
    }

    public static NBTTagList writeItemStacksToTag(List<ItemStack> items, int maxQuantity) {
        return ItemStackUtils.writeItemStacksToTag(items, maxQuantity, null);
    }

    public static NBTTagList writeItemStacksToTag(List<ItemStack> items, int maxQuantity, BiConsumer<ItemStack, NBTTagCompound> callbackMethod) {
        NBTTagList tagList = new NBTTagList();
        int max = items.size();
        for (int i = 0; i < max; ++i) {
            ItemStack stack = items.get(i);
            if (!ItemStackUtils.isValid(stack)) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("Slot", (short)i);
            stack.func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", Math.min(stack.func_190916_E(), maxQuantity));
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)Math.min(stack.func_190916_E(), maxQuantity));
            } else {
                tag.func_74774_a("Quantity", (byte)Math.min(stack.func_190916_E(), maxQuantity));
            }
            if (callbackMethod != null) {
                NBTTagCompound stackNbt = new NBTTagCompound();
                callbackMethod.accept(stack, stackNbt);
                tag.func_74782_a("StackNBT", (NBTBase)stackNbt);
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        ItemStackUtils.readItemStacksFromTag(items, tagList, null);
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList, BiConsumer<ItemStack, NBTTagCompound> callbackMethod) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            short slot = tag.func_74765_d("Slot");
            items[slot] = new ItemStack(tag);
            if (tag.func_74764_b("Quantity")) {
                items[slot].func_190920_e(((NBTPrimitive)tag.func_74781_a("Quantity")).func_150287_d());
            }
            if (callbackMethod == null || !tag.func_74764_b("StackNBT")) continue;
            callbackMethod.accept(items[slot], (NBTTagCompound)tag.func_74781_a("StackNBT"));
        }
    }

    public static void readItemStacksFromTag(List<ItemStack> items, NBTTagList tagList) {
        ItemStackUtils.readItemStacksFromTag(items, tagList, null);
    }

    public static void readItemStacksFromTag(List<ItemStack> items, NBTTagList tagList, BiConsumer<ItemStack, NBTTagCompound> callbackMethod) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            short slot = tag.func_74765_d("Slot");
            items.set(slot, new ItemStack(tag));
            if (tag.func_74764_b("Quantity")) {
                items.get(slot).func_190920_e(((NBTPrimitive)tag.func_74781_a("Quantity")).func_150287_d());
            }
            if (callbackMethod == null || !tag.func_74764_b("StackNBT")) continue;
            callbackMethod.accept(items.get(slot), (NBTTagCompound)tag.func_74781_a("StackNBT"));
        }
    }

    public static void dropBlockItem(ItemStack stack, World world, BlockPos pos) {
        if (ItemStackUtils.isValid(stack)) {
            float xOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            float yOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            float zOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + xOff), (double)((float)pos.func_177956_o() + yOff), (double)((float)pos.func_177952_p() + zOff), stack.func_77946_l());
            float motionSpeed = 0.05f;
            item.field_70159_w = (float)MiscUtils.RNG.randomGaussian() * 0.05f;
            item.field_70181_x = (float)MiscUtils.RNG.randomGaussian() * 0.05f + 0.2f;
            item.field_70179_y = (float)MiscUtils.RNG.randomGaussian() * 0.05f;
            world.func_72838_d((Entity)item);
        }
    }

    public static NonNullList<ItemStack> getCompactItems(NonNullList<ItemStack> items, int maxInvStackSize) {
        return ItemStackUtils.getCompactItems(items, maxInvStackSize, null);
    }

    public static NonNullList<ItemStack> getCompactItems(NonNullList<ItemStack> items, int maxInvStackSize, Integer maxStackSize) {
        NonNullList cmpItems = NonNullList.func_191196_a();
        items.sort((i1, i2) -> ItemStackUtils.areEqual(i1, i2, false, true, true) ? 0 : i1.func_77977_a().compareTo(i2.func_77977_a()));
        items.forEach(v -> {
            int cmpSize = cmpItems.size();
            if (cmpSize < 1) {
                cmpItems.add((Object)v.func_77946_l());
            } else {
                ItemStack cs = (ItemStack)cmpItems.get(cmpSize - 1);
                if (ItemStackUtils.areEqual(cs, v, false, true, true)) {
                    int rest = Math.min(MiscUtils.defIfNull(maxStackSize, () -> ((ItemStack)cs).func_77976_d()), maxInvStackSize) - cs.func_190916_E();
                    if (rest >= v.func_190916_E()) {
                        cs.func_190917_f(v.func_190916_E());
                    } else {
                        cs.func_190917_f(rest);
                        ItemStack restStack = v.func_77946_l();
                        restStack.func_190918_g(rest);
                        cmpItems.add((Object)restStack);
                    }
                } else {
                    cmpItems.add((Object)v.func_77946_l());
                }
            }
        });
        return cmpItems;
    }
}

