/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

final class JsonNbtReader {
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");

    JsonNbtReader() {
    }

    static NBTTagCompound getTagFromJson(JsonElement elem) {
        if (!elem.isJsonObject()) {
            throw new JsonParseException("NBT element must be an object!");
        }
        JsonObject obj = elem.getAsJsonObject();
        NBTTagCompound nbt = new NBTTagCompound();
        obj.entrySet().forEach(entry -> {
            JsonElement entryElem = (JsonElement)entry.getValue();
            if (entryElem.isJsonObject()) {
                nbt.func_74782_a((String)entry.getKey(), (NBTBase)JsonNbtReader.getTagFromJson(entryElem));
            } else if (entryElem.isJsonPrimitive()) {
                nbt.func_74782_a((String)entry.getKey(), JsonNbtReader.getTyped(entryElem.getAsJsonPrimitive()));
            } else if (entryElem.isJsonArray()) {
                nbt.func_74782_a((String)entry.getKey(), JsonNbtReader.getArray(entryElem.getAsJsonArray()));
            } else {
                throw new JsonParseException("Unable to identify type for JSON-Object. Is it null?");
            }
        });
        return nbt;
    }

    static NBTBase getArray(JsonArray array) {
        if (array.size() > 0) {
            JsonElement firstElem = array.get(0);
            NBTPrimitive firstPrimitive = JsonNbtReader.getPrimitive(firstElem);
            if (firstPrimitive != null) {
                if (firstPrimitive.func_74732_a() == 1) {
                    byte[] bytes = new byte[array.size()];
                    bytes[0] = firstPrimitive.func_150290_f();
                    int max = bytes.length;
                    for (int i = 1; i < max; ++i) {
                        bytes[i] = JsonNbtReader.getPrimitive(array.get(i), 1).func_150290_f();
                    }
                    return new NBTTagByteArray(bytes);
                }
                if (firstPrimitive.func_74732_a() == 3) {
                    int[] ints = new int[array.size()];
                    ints[0] = firstPrimitive.func_150287_d();
                    int max = ints.length;
                    for (int i = 1; i < max; ++i) {
                        ints[i] = JsonNbtReader.getPrimitive(array.get(i), 3).func_150287_d();
                    }
                    return new NBTTagIntArray(ints);
                }
                if (firstPrimitive.func_74732_a() == 4) {
                    long[] longs = new long[array.size()];
                    longs[0] = firstPrimitive.func_150291_c();
                    int max = longs.length;
                    for (int i = 1; i < max; ++i) {
                        longs[i] = JsonNbtReader.getPrimitive(array.get(i), 4).func_150291_c();
                    }
                    return new NBTTagLongArray(longs);
                }
            }
            if (firstElem.isJsonPrimitive()) {
                NBTBase firstTyped = JsonNbtReader.getTyped(firstElem.getAsJsonPrimitive());
                NBTTagList list = new NBTTagList();
                list.func_74742_a(firstTyped);
                int max = array.size();
                for (int i = 1; i < max; ++i) {
                    NBTBase arrElemTyped;
                    JsonElement arrElem = array.get(i);
                    if (arrElem.isJsonPrimitive()) {
                        arrElemTyped = JsonNbtReader.getTyped(arrElem.getAsJsonPrimitive());
                        if (arrElemTyped.func_74732_a() != firstTyped.func_74732_a()) {
                            throw new JsonParseException("Cannot add mismatching NBT types to NBT list");
                        }
                    } else {
                        throw new JsonParseException("Cannot add mismatching NBT types to NBT list");
                    }
                    list.func_74742_a(arrElemTyped);
                }
                return list;
            }
            if (firstElem.isJsonObject()) {
                NBTTagCompound firstNBT = JsonNbtReader.getTagFromJson(firstElem);
                NBTTagList list = new NBTTagList();
                list.func_74742_a((NBTBase)firstNBT);
                int max = array.size();
                for (int i = 1; i < max; ++i) {
                    JsonElement arrElem = array.get(i);
                    if (!arrElem.isJsonObject()) {
                        throw new JsonParseException("Cannot add mismatching NBT types to NBT list");
                    }
                    list.func_74742_a((NBTBase)JsonNbtReader.getTagFromJson(arrElem));
                }
                return list;
            }
            if (firstElem.isJsonArray()) {
                NBTBase firstArray = JsonNbtReader.getArray(firstElem.getAsJsonArray());
                NBTTagList list = new NBTTagList();
                list.func_74742_a(firstArray);
                int max = array.size();
                for (int i = 1; i < max; ++i) {
                    NBTBase arrElemArray;
                    JsonElement arrElem = array.get(i);
                    if (arrElem.isJsonArray()) {
                        arrElemArray = JsonNbtReader.getArray(arrElem.getAsJsonArray());
                        if (arrElemArray.func_74732_a() != firstArray.func_74732_a()) {
                            throw new JsonParseException("Cannot add mismatching NBT types to NBT list");
                        }
                    } else {
                        throw new JsonParseException("Cannot add mismatching NBT types to NBT list");
                    }
                    list.func_74742_a(arrElemArray);
                }
            }
            throw new JsonParseException("Unable to identify array type");
        }
        throw new JsonParseException("Cannot parse an empty array");
    }

    static NBTPrimitive getPrimitive(JsonElement elem) {
        if (elem.isJsonPrimitive()) {
            return (NBTPrimitive)JsonNbtReader.getTyped(elem.getAsJsonPrimitive());
        }
        return null;
    }

    static NBTPrimitive getPrimitive(JsonElement elem, int typeId) {
        if (elem.isJsonPrimitive()) {
            NBTBase nbt = JsonNbtReader.getTyped(elem.getAsJsonPrimitive());
            if (nbt.func_74732_a() == typeId) {
                return (NBTPrimitive)nbt;
            }
            throw new JsonParseException(String.format("The array cannot contain mixed types! Expected a type with NBT-ID %d here.", typeId));
        }
        throw new JsonParseException(String.format("The array cannot contain mixed types! Expected a type with NBT-ID %d here.", typeId));
    }

    static NBTBase getTyped(JsonPrimitive primitive) {
        if (primitive.isNumber()) {
            Number nbr = primitive.getAsNumber();
            if (nbr instanceof Float) {
                return new NBTTagFloat(nbr.floatValue());
            }
            if (nbr instanceof Byte) {
                return new NBTTagByte(nbr.byteValue());
            }
            if (nbr instanceof Short) {
                return new NBTTagShort(nbr.shortValue());
            }
            if (nbr instanceof Long) {
                return new NBTTagLong(nbr.longValue());
            }
            if (nbr instanceof Integer) {
                return new NBTTagInt(nbr.intValue());
            }
            if (nbr instanceof Double) {
                return new NBTTagDouble(nbr.doubleValue());
            }
            throw new JsonParseException("Cannot parse unknown number type!");
        }
        if (primitive.isBoolean()) {
            return new NBTTagByte((byte)(primitive.getAsBoolean() ? 1 : 0));
        }
        if (primitive.isString()) {
            return JsonNbtReader.tryGetTypedFromString(primitive.getAsString());
        }
        throw new JsonParseException("Cannot parse unknown primitive!");
    }

    static NBTBase tryGetTypedFromString(String s) {
        if (FLOAT_PATTERN.matcher(s).matches()) {
            return new NBTTagFloat(Float.parseFloat(s.substring(0, s.length() - 1)));
        }
        if (BYTE_PATTERN.matcher(s).matches()) {
            return new NBTTagByte(Byte.parseByte(s.substring(0, s.length() - 1)));
        }
        if (SHORT_PATTERN.matcher(s).matches()) {
            return new NBTTagShort(Short.parseShort(s.substring(0, s.length() - 1)));
        }
        if (LONG_PATTERN.matcher(s).matches()) {
            return new NBTTagLong(Long.parseLong(s.substring(0, s.length() - 1)));
        }
        if (INT_PATTERN.matcher(s).matches()) {
            return new NBTTagInt(Integer.parseInt(s));
        }
        if (DOUBLE_PATTERN.matcher(s).matches()) {
            return new NBTTagDouble(Double.parseDouble(s.substring(0, s.length() - 1)));
        }
        if (DOUBLE_PATTERN_NOSUFFIX.matcher(s).matches()) {
            return new NBTTagDouble(Double.parseDouble(s));
        }
        return new NBTTagString(s);
    }
}

