/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonNbtReader;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Range;

public final class JsonUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Range<Integer> FULL_ARRAY_RANGE = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));

    public static <T> T fromJson(Reader reader, Class<T> clazz) {
        JsonReader jsonReader = new JsonReader(reader);
        try {
            return (T)GSON.getAdapter(clazz).read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public static float getFloatVal(JsonElement json) {
        JsonUtils.requirePrimitive(json);
        return json.getAsFloat();
    }

    public static float getFloatVal(JsonElement json, float defVal) {
        if (json == null || !json.isJsonPrimitive()) {
            return defVal;
        }
        return json.getAsFloat();
    }

    public static double getDoubleVal(JsonElement json) {
        JsonUtils.requirePrimitive(json);
        return json.getAsDouble();
    }

    public static double getDoubleVal(JsonElement json, double defVal) {
        if (json == null || !json.isJsonPrimitive()) {
            return defVal;
        }
        return json.getAsDouble();
    }

    public static String getStringVal(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected value to be a primitive");
        }
        return json.getAsString();
    }

    public static String getStringVal(JsonElement json, String defVal) {
        if (json == null || !json.isJsonPrimitive()) {
            return defVal;
        }
        return json.getAsString();
    }

    public static int getIntVal(JsonElement json) {
        JsonUtils.requirePrimitive(json);
        return json.getAsInt();
    }

    public static int getIntVal(JsonElement json, int defVal) {
        if (json == null || !json.isJsonPrimitive()) {
            return defVal;
        }
        return json.getAsInt();
    }

    public static boolean getBoolVal(JsonElement json) {
        JsonUtils.requirePrimitive(json);
        return json.getAsBoolean();
    }

    public static boolean getBoolVal(JsonElement json, boolean defVal) {
        if (json == null || !json.isJsonPrimitive()) {
            return defVal;
        }
        return json.getAsBoolean();
    }

    public static ResourceLocation getLocation(JsonElement json) {
        if (json != null && json.isJsonObject()) {
            JsonObject jObj = json.getAsJsonObject();
            String namespace = JsonUtils.getStringVal(jObj.get("namespace"), "minecraft");
            String path = JsonUtils.getStringVal(jObj.get("path"), null);
            if (path != null) {
                return new ResourceLocation(namespace, path);
            }
            throw new JsonSyntaxException("JSON-Object needs at least an element named \"path\" for a Resource Location");
        }
        JsonUtils.requirePrimitive(json);
        return new ResourceLocation(json.getAsString());
    }

    public static ResourceLocation getLocation(JsonElement json, ResourceLocation defVal) {
        if (json != null && json.isJsonObject()) {
            JsonObject jObj = json.getAsJsonObject();
            String namespace = JsonUtils.getStringVal(jObj.get("namespace"), "minecraft");
            String path = JsonUtils.getStringVal(jObj.get("path"), null);
            if (path != null) {
                return new ResourceLocation(namespace, path);
            }
            return defVal;
        }
        if (json == null || !json.isJsonPrimitive()) {
            return defVal;
        }
        return new ResourceLocation(json.getAsString());
    }

    private static void requirePrimitive(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (!json.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected value to needs be a primitive");
        }
    }

    public static int[] getIntArray(JsonElement json) {
        return JsonUtils.getIntArray(json, FULL_ARRAY_RANGE);
    }

    public static int[] getIntArray(JsonElement json, Range<Integer> requiredSize) {
        JsonUtils.requirePrimitiveArray(json, requiredSize);
        return (int[])GSON.fromJson(json, int[].class);
    }

    public static int[] getIntArray(JsonElement json, int[] defVal) {
        return JsonUtils.getIntArray(json, defVal, FULL_ARRAY_RANGE);
    }

    public static int[] getIntArray(JsonElement json, int[] defVal, Range<Integer> requiredSize) {
        if (JsonUtils.isNotPrimitiveArray(json, requiredSize)) {
            return defVal;
        }
        return (int[])GSON.fromJson(json, int[].class);
    }

    public static double[] getDoubleArray(JsonElement json) {
        return JsonUtils.getDoubleArray(json, FULL_ARRAY_RANGE);
    }

    public static double[] getDoubleArray(JsonElement json, Range<Integer> requiredSize) {
        JsonUtils.requirePrimitiveArray(json, requiredSize);
        return (double[])GSON.fromJson(json, double[].class);
    }

    public static double[] getDoubleArray(JsonElement json, double[] defVal) {
        return JsonUtils.getDoubleArray(json, defVal, FULL_ARRAY_RANGE);
    }

    public static double[] getDoubleArray(JsonElement json, double[] defVal, Range<Integer> requiredSize) {
        if (JsonUtils.isNotPrimitiveArray(json, requiredSize)) {
            return defVal;
        }
        return (double[])GSON.fromJson(json, double[].class);
    }

    public static String[] getStringArray(JsonElement json) {
        return JsonUtils.getStringArray(json, FULL_ARRAY_RANGE);
    }

    public static String[] getStringArray(JsonElement json, Range<Integer> requiredSize) {
        JsonUtils.requirePrimitiveArray(json, requiredSize);
        return (String[])GSON.fromJson(json, String[].class);
    }

    public static String[] getStringArray(JsonElement json, String[] defVal) {
        return JsonUtils.getStringArray(json, defVal, FULL_ARRAY_RANGE);
    }

    public static String[] getStringArray(JsonElement json, String[] defVal, Range<Integer> requiredSize) {
        if (JsonUtils.isNotPrimitiveArray(json, requiredSize)) {
            return defVal;
        }
        return (String[])GSON.fromJson(json, String[].class);
    }

    private static boolean isNotPrimitiveArray(JsonElement json, Range<Integer> requiredSize) {
        if (json == null || !json.isJsonArray()) {
            return true;
        }
        JsonArray arr = json.getAsJsonArray();
        return !requiredSize.contains((Object)arr.size()) || arr.size() > 0 && !arr.get(0).isJsonPrimitive();
    }

    private static JsonArray requireArray(JsonElement json, Range<Integer> requiredSize) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (!json.isJsonArray()) {
            throw new JsonSyntaxException("Expected value needs to be an array");
        }
        JsonArray arr = json.getAsJsonArray();
        if (!requiredSize.contains((Object)arr.size())) {
            int min = (Integer)requiredSize.getMinimum();
            int max = (Integer)requiredSize.getMaximum();
            throw new JsonSyntaxException("Expected array's size needs to be " + (min == max ? Integer.toString(min) : String.format("between %d and %d", min, max)) + "elements big");
        }
        return arr;
    }

    private static void requirePrimitiveArray(JsonElement json, Range<Integer> requiredSize) {
        JsonArray arr = JsonUtils.requireArray(json, requiredSize);
        if (arr.size() > 0 && !arr.get(0).isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected array needs to contain primitive values");
        }
    }

    @Nonnull
    public static ItemStack getItemStack(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (json.isJsonArray()) {
            throw new JsonSyntaxException("Expected value to be an object, not an array");
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted value to be an object");
        }
        return JsonUtils.getStack((JsonObject)json);
    }

    @Nonnull
    public static NonNullList<ItemStack> getItemStacks(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        return JsonUtils.getStacks(json);
    }

    private static ItemStack getStack(JsonObject jsonObj) {
        ItemStack stack;
        String itemName = JsonUtils.getStringVal(jsonObj.get("item"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonParseException(String.format("Unknown item '%s'", itemName));
        }
        if (item.func_77614_k() && !jsonObj.has("data")) {
            throw new JsonParseException(String.format("Missing data for item '%s'", itemName));
        }
        if (jsonObj.has("nbt")) {
            NBTTagCompound nbt = JsonNbtReader.getTagFromJson(jsonObj.get("nbt"));
            NBTTagCompound tmp = new NBTTagCompound();
            if (nbt.func_74764_b("ForgeCaps")) {
                tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                nbt.func_82580_o("ForgeCaps");
            }
            tmp.func_74782_a("tag", (NBTBase)nbt);
            tmp.func_74778_a("id", itemName);
            tmp.func_74768_a("Count", JsonUtils.getIntVal(jsonObj.get("count"), 1));
            tmp.func_74768_a("Damage", JsonUtils.getIntVal(jsonObj.get("data"), 0));
            stack = new ItemStack(tmp);
        } else {
            stack = new ItemStack(item, JsonUtils.getIntVal(jsonObj.get("count"), 1), JsonUtils.getIntVal(jsonObj.get("data"), 0));
        }
        if (!ItemStackUtils.isValid(stack)) {
            throw new JsonParseException("Invalid Item: " + stack.toString());
        }
        return stack;
    }

    private static NonNullList<ItemStack> getStacks(JsonElement json) {
        NonNullList items = NonNullList.func_191196_a();
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (json.isJsonArray()) {
            json.getAsJsonArray().forEach(elem -> {
                if (elem == null || !elem.isJsonObject()) {
                    throw new JsonSyntaxException("Expcted stack to be an object");
                }
                items.addAll(JsonUtils.getStacks(elem));
            });
        } else if (json.isJsonObject()) {
            JsonObject jsonObj = json.getAsJsonObject();
            if (jsonObj.has("type") && MiscUtils.defIfNull(jsonObj.get("type").getAsString(), "").equals("forge:ore_dict")) {
                String oredictName = jsonObj.get("ore").getAsString();
                items.addAll((Collection)OreDictionary.getOres((String)oredictName).stream().map(ItemStack::func_77946_l).collect(Collectors.toList()));
            } else {
                items.add((Object)JsonUtils.getStack(jsonObj));
            }
        } else {
            throw new JsonSyntaxException("Expected stack(s) to be an object or an array of objects");
        }
        return items;
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, String val) {
        if (!jobj.has(name)) {
            jobj.addProperty(name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, Boolean val) {
        if (!jobj.has(name)) {
            jobj.addProperty(name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, Character val) {
        if (!jobj.has(name)) {
            jobj.addProperty(name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, Number val) {
        if (!jobj.has(name)) {
            jobj.addProperty(name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, String[] val) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, Boolean[] val) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, Character[] val) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, Number[] val) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, val);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, int[] arr) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, arr);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, long[] arr) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, arr);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, double[] arr) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, arr);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, byte[] arr) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, arr);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, short[] arr) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, arr);
        }
    }

    public static void addDefaultJsonProperty(JsonObject jobj, String name, float[] arr) {
        if (!jobj.has(name)) {
            JsonUtils.addJsonProperty(jobj, name, arr);
        }
    }

    private static Number[] convertNArray(Object arr) {
        if (arr instanceof int[]) {
            return (Number[])Arrays.stream((int[])arr).mapToObj(e -> e).toArray(Number[]::new);
        }
        if (arr instanceof long[]) {
            return (Number[])Arrays.stream((long[])arr).mapToObj(e -> e).toArray(Number[]::new);
        }
        if (arr instanceof double[]) {
            return (Number[])Arrays.stream((double[])arr).mapToObj(e -> e).toArray(Number[]::new);
        }
        if (arr instanceof byte[]) {
            byte[] na = (byte[])arr;
            return (Number[])IntStream.range(0, na.length).mapToObj(i -> na[i]).toArray(Number[]::new);
        }
        if (arr instanceof short[]) {
            short[] na = (short[])arr;
            return (Number[])IntStream.range(0, na.length).mapToObj(i -> na[i]).toArray(Number[]::new);
        }
        if (arr instanceof float[]) {
            float[] na = (float[])arr;
            return (Number[])IntStream.range(0, na.length).mapToObj(i -> Float.valueOf(na[i])).toArray(Number[]::new);
        }
        throw new IllegalArgumentException("The given array does not hold numeric values!");
    }

    public static void addJsonProperty(JsonObject jobj, String name, String val) {
        jobj.addProperty(name, val);
    }

    public static void addJsonProperty(JsonObject jobj, String name, Boolean val) {
        jobj.addProperty(name, val);
    }

    public static void addJsonProperty(JsonObject jobj, String name, Character val) {
        jobj.addProperty(name, val);
    }

    public static void addJsonProperty(JsonObject jobj, String name, Number val) {
        jobj.addProperty(name, val);
    }

    public static void addJsonProperty(JsonObject jobj, String name, int[] arr) {
        JsonUtils.addJsonProperty(jobj, name, JsonUtils.convertNArray(arr));
    }

    public static void addJsonProperty(JsonObject jobj, String name, long[] arr) {
        JsonUtils.addJsonProperty(jobj, name, JsonUtils.convertNArray(arr));
    }

    public static void addJsonProperty(JsonObject jobj, String name, double[] arr) {
        JsonUtils.addJsonProperty(jobj, name, JsonUtils.convertNArray(arr));
    }

    public static void addJsonProperty(JsonObject jobj, String name, byte[] arr) {
        JsonUtils.addJsonProperty(jobj, name, JsonUtils.convertNArray(arr));
    }

    public static void addJsonProperty(JsonObject jobj, String name, short[] arr) {
        JsonUtils.addJsonProperty(jobj, name, JsonUtils.convertNArray(arr));
    }

    public static void addJsonProperty(JsonObject jobj, String name, float[] arr) {
        JsonUtils.addJsonProperty(jobj, name, JsonUtils.convertNArray(arr));
    }

    public static void addJsonProperty(JsonObject jobj, String name, Number[] arr) {
        JsonArray jarr = new JsonArray();
        for (Number i : arr) {
            jarr.add(i);
        }
        jobj.add(name, (JsonElement)jarr);
    }

    public static void addJsonProperty(JsonObject jobj, String name, String[] arr) {
        JsonArray jarr = new JsonArray();
        for (String i : arr) {
            jarr.add(i);
        }
        jobj.add(name, (JsonElement)jarr);
    }

    public static void addJsonProperty(JsonObject jobj, String name, Boolean[] arr) {
        JsonArray jarr = new JsonArray();
        for (Boolean i : arr) {
            jarr.add(i);
        }
        jobj.add(name, (JsonElement)jarr);
    }

    public static void addJsonProperty(JsonObject jobj, String name, Character[] arr) {
        JsonArray jarr = new JsonArray();
        for (Character i : arr) {
            jarr.add(i);
        }
        jobj.add(name, (JsonElement)jarr);
    }

    public static JsonObject deepCopy(JsonObject obj) {
        return (JsonObject)GSON.fromJson(GSON.toJson((JsonElement)obj), JsonObject.class);
    }

    @Nullable
    public static <T> T gsonDeserialize(Gson gsonIn, Reader readerIn, Class<T> adapter, boolean lenient) {
        return (T)net.minecraft.util.JsonUtils.func_188173_a((Gson)gsonIn, (Reader)readerIn, adapter, (boolean)lenient);
    }
}

