/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public final class LangUtils {
    public static final TranslateKey LEXICON_GROUP_NAME = new TranslateKey("%s.lexicon.%%s.%%s.name", "sanlib");
    public static final TranslateKey LEXICON_ENTRY_NAME = new TranslateKey("%s.lexicon.%%s.%%s.%%s.name", "sanlib");
    public static final TranslateKey LEXICON_ENTRY_TEXT = new TranslateKey("%s.lexicon.%%s.%%s.%%s.text", "sanlib");
    public static final TranslateKey LEXICON_SRC_ENTRY_TITLE = new TranslateKey("%s.lexicon.%%s.search.title", "sanlib");
    public static final TranslateKey LEXICON_SRC_ENTRY_TEXT = new TranslateKey("%s.lexicon.%%s.search.text", "sanlib");
    public static final TranslateKey ENTITY_NAME = new TranslateKey("entity.%s.name");
    public static final TranslateKey ENTITY_DESC = new TranslateKey("entity.%s.desc");
    public static final TranslateKey CONTAINER_INV = new TranslateKey("container.inventory");

    public static String translate(String langKey, Object ... args) {
        String s = I18n.func_94522_b((String)langKey) ? (args == null || args.length < 1 ? I18n.func_74838_a((String)langKey) : I18n.func_74837_a((String)langKey, (Object[])args)) : langKey;
        return s.replace("\\n", "\n");
    }

    public static String translate(TranslateKey langKey, Object ... args) {
        return LangUtils.translate(langKey.key, args);
    }

    public static String translateOrDefault(String langKey, String defaultVal) {
        return I18n.func_94522_b((String)langKey) ? LangUtils.translate(langKey, new Object[0]) : defaultVal;
    }

    public static String translateOrDefault(TranslateKey langKey, String defaultVal) {
        return LangUtils.translateOrDefault(langKey.key, defaultVal);
    }

    public static String translateEntityCls(Class<? extends Entity> eClass) {
        String namedEntry = EntityList.func_191302_a((ResourceLocation)EntityList.func_191306_a(eClass));
        if (namedEntry != null) {
            return LangUtils.translate(ENTITY_NAME.get(namedEntry), new Object[0]);
        }
        return "[UNKNOWN] " + eClass.getName();
    }

    public static String translateEntityClsDesc(Class<? extends Entity> eClass) {
        String namedEntry = EntityList.func_191302_a((ResourceLocation)EntityList.func_191306_a(eClass));
        if (namedEntry != null) {
            return LangUtils.translate(ENTITY_DESC.get(namedEntry), new Object[0]);
        }
        return "";
    }

    public static final class TranslateKey {
        private final String key;

        public TranslateKey(String key) {
            this.key = key;
        }

        public TranslateKey(String key, Object ... args) {
            this(String.format(key, args));
        }

        public String get() {
            return this.key;
        }

        public String get(Object ... args) {
            return String.format(this.key, args);
        }
    }
}

