/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import com.google.common.collect.ImmutableMap;
import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.lib.XorShiftRandom;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public final class MiscUtils {
    public static final XorShiftRandom RNG = new XorShiftRandom();

    public static Double calcFormula(final String str) {
        return (new Object(){
            private int pos = -1;
            private int ch;

            private void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            private boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            private Double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < str.length()) {
                    return null;
                }
                return x;
            }

            private double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            private double parseTerm() {
                Double x = this.parseFactor();
                if (x == null) {
                    return 0.0;
                }
                while (true) {
                    if (this.eat(42)) {
                        x = x * this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x = x / this.parseFactor();
                }
                return x;
            }

            private Double parseFactor() {
                Double x;
                double sign = 1.0;
                while (true) {
                    if (this.eat(43)) {
                        continue;
                    }
                    if (!this.eat(45)) break;
                    sign *= -1.0;
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    this.eat(41);
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(str.substring(startPos, this.pos));
                } else if (this.ch >= 97 && this.ch <= 122) {
                    while (this.ch >= 97 && this.ch <= 122) {
                        this.nextChar();
                    }
                    String func = str.substring(startPos, this.pos);
                    x = this.parseFactor();
                    if (x == null) {
                        return null;
                    }
                    switch (func) {
                        case "sqrt": {
                            x = Math.sqrt(x);
                            break;
                        }
                        case "sin": {
                            x = StrictMath.sin(Math.toRadians(x));
                            break;
                        }
                        case "asin": {
                            x = StrictMath.asin(Math.toRadians(x));
                            break;
                        }
                        case "cos": {
                            x = StrictMath.cos(Math.toRadians(x));
                            break;
                        }
                        case "acos": {
                            x = StrictMath.acos(Math.toRadians(x));
                            break;
                        }
                        case "tan": {
                            x = StrictMath.tan(Math.toRadians(x));
                            break;
                        }
                        case "atan": {
                            x = StrictMath.atan(Math.toRadians(x));
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                } else {
                    return null;
                }
                if (this.eat(94)) {
                    Double y = this.parseFactor();
                    if (y == null) {
                        return null;
                    }
                    x = StrictMath.pow(x, y);
                }
                return x * sign;
            }
        }).parse();
    }

    public static String getTimeFromTicks(int ticks) {
        return MiscUtils.getTimeFromTicks(ticks, 2);
    }

    public static int hexToInt(String hex) {
        if (hex.startsWith("0x")) {
            hex = hex.substring(2);
        } else if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        try {
            return (int)Long.parseLong(hex, 16);
        }
        catch (NumberFormatException ex) {
            SanLib.LOG.log(Level.ERROR, String.format("cannot parse hexadecimal number string %s", hex), (Throwable)ex);
            return 0;
        }
    }

    public static String getTimeFromTicks(int ticks, int secondsPrecision) {
        int hours = ticks / 72000;
        int minutes = (ticks - hours * 72000) / 1200;
        float seconds = (float)(ticks - hours * 72000 - minutes * 1200) / 20.0f;
        StringBuilder sb = new StringBuilder();
        if (hours > 0) {
            sb.append(String.format("%dh", hours));
        }
        if (minutes > 0) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(String.format("%dm", minutes));
        }
        if (seconds > 0.0f) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            DecimalFormat df = new DecimalFormat("#.#");
            df.setMaximumFractionDigits(secondsPrecision);
            sb.append(String.format("%ss", df.format(seconds)));
        }
        return sb.toString();
    }

    public static String getListNrWithSuffix(int nr) {
        String nrStr = Integer.toString(nr);
        if (nrStr.endsWith("11") || nrStr.endsWith("12") || nrStr.endsWith("13")) {
            return nrStr + "th";
        }
        char lastNum = nrStr.charAt(nrStr.length() - 1);
        switch (lastNum) {
            case '1': {
                return nrStr + "st";
            }
            case '2': {
                return nrStr + "nd";
            }
            case '3': {
                return nrStr + "rd";
            }
        }
        return nrStr + "th";
    }

    public static boolean between(float lo, float val, float hi) {
        return hi < lo ? hi <= val && val <= lo : lo <= val && val <= hi;
    }

    public static <T> T defIfNull(T val, T def) {
        return val != null ? val : def;
    }

    public static <T> T defIfNull(T val, Supplier<T> def) {
        return val != null ? val : def.get();
    }

    public static <T> void call(T obj, Consumer<T> onNonNull) {
        if (obj != null) {
            onNonNull.accept(obj);
        }
    }

    public static <T, R> R call(T obj, Function<T, R> onNonNull) {
        return obj != null ? (R)onNonNull.apply(obj) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor) {
        File source = mod.getSource();
        if (!source.isFile()) {
            if (!source.isDirectory()) return false;
            return MiscUtils.findFilesIntrn(source.toPath().resolve(base), mod, preprocessor, processor);
        }
        try (FileSystem fs = FileSystems.newFileSystem(source.toPath(), null);){
            boolean bl = MiscUtils.findFilesIntrn(fs.getPath('/' + base, new String[0]), mod, preprocessor, processor);
            return bl;
        }
        catch (IOException e) {
            SanLib.LOG.log(Level.ERROR, "Error loading FileSystem from jar: ", (Throwable)e);
            return false;
        }
    }

    private static boolean findFilesIntrn(Path root, ModContainer mod, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return false;
        }
        if (preprocessor != null && !MiscUtils.defIfNull(preprocessor.apply(root), false).booleanValue()) {
            return false;
        }
        if (processor != null) {
            Iterator itr;
            try {
                itr = Files.walk(root, new FileVisitOption[0]).iterator();
            }
            catch (IOException e) {
                SanLib.LOG.log(Level.ERROR, String.format("Error iterating filesystem for: %s", mod.getModId()), (Throwable)e);
                return false;
            }
            while (itr.hasNext()) {
                if (MiscUtils.defIfNull(processor.apply(root, (Path)itr.next()), false).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean doesNbtContainOther(NBTTagCompound mainNBT, NBTTagCompound otherNBT) {
        return MiscUtils.doesNbtContainOther(mainNBT, otherNBT, true);
    }

    public static boolean doesNbtContainOther(NBTTagCompound mainNBT, NBTTagCompound otherNBT, boolean strict) {
        return otherNBT == null || mainNBT != null && otherNBT.func_150296_c().stream().allMatch(key -> {
            if (mainNBT.func_74764_b(key)) {
                if (strict) {
                    return mainNBT.func_150299_b(key) == otherNBT.func_150299_b(key) && mainNBT.func_74781_a(key).equals((Object)otherNBT.func_74781_a(key));
                }
                return MiscUtils.compareNBTBase(mainNBT.func_74781_a(key), otherNBT.func_74781_a(key));
            }
            return false;
        });
    }

    private static boolean compareNBTBase(NBTBase main, NBTBase other) {
        if (main instanceof NBTPrimitive && other instanceof NBTPrimitive) {
            NBTPrimitive mainBase = (NBTPrimitive)main;
            NBTPrimitive otherBase = (NBTPrimitive)other;
            long mainNb = MiscUtils.isNbtDouble((NBTBase)mainBase) ? Double.doubleToLongBits(mainBase.func_150286_g()) : mainBase.func_150291_c();
            long otherNb = MiscUtils.isNbtDouble((NBTBase)otherBase) ? Double.doubleToLongBits(otherBase.func_150286_g()) : otherBase.func_150291_c();
            return mainNb == otherNb;
        }
        if (main instanceof NBTTagList && other instanceof NBTTagList) {
            NBTTagList mainList = (NBTTagList)main;
            NBTTagList otherList = (NBTTagList)other.func_74737_b();
            if (mainList.func_150303_d() == otherList.func_150303_d()) {
                block0: for (int i = mainList.func_74745_c() - 1; i >= 0 && otherList.func_74745_c() > 0; --i) {
                    for (int j = otherList.func_74745_c() - 1; j >= 0; --j) {
                        if (!MiscUtils.compareNBTBase(mainList.func_179238_g(i), otherList.func_179238_g(j))) continue;
                        otherList.func_74744_a(j);
                        continue block0;
                    }
                }
                return otherList.func_74745_c() == 0;
            }
            return false;
        }
        if (main instanceof NBTTagCompound && other instanceof NBTTagCompound) {
            return MiscUtils.doesNbtContainOther((NBTTagCompound)main, (NBTTagCompound)other, false);
        }
        return main.equals((Object)other);
    }

    private static boolean isNbtDouble(NBTBase base) {
        return base instanceof NBTTagDouble || base instanceof NBTTagFloat;
    }

    public static float wrap360(float angle) {
        return angle >= 360.0f ? MiscUtils.wrap360(angle - 360.0f) : (angle < 0.0f ? MiscUtils.wrap360(angle + 360.0f) : angle);
    }

    public static <T, R> R applyNonNull(T nullableObj, Function<T, R> onNonNull, R defReturn) {
        if (nullableObj != null) {
            return onNonNull.apply(nullableObj);
        }
        return defReturn;
    }

    public static BlockStateContainer buildCustomBlockStateContainer(Block block, final BiFunction<Block, ImmutableMap<IProperty<?>, Comparable<?>>, BlockStateContainer.StateImplementation> stateImplCtor, IProperty<?> ... properties) {
        return new BlockStateContainer(block, properties){

            @Nonnull
            protected BlockStateContainer.StateImplementation createState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
                return (BlockStateContainer.StateImplementation)stateImplCtor.apply(block, properties);
            }
        };
    }

    public static void readFile(ModContainer mod, String file, Consumer<BufferedReader> c) {
        block16: {
            File source = mod.getSource();
            try {
                if (source.isFile()) {
                    try (FileSystem fs = FileSystems.newFileSystem(source.toPath(), null);){
                        c.accept(Files.newBufferedReader(fs.getPath('/' + file, new String[0]), StandardCharsets.UTF_8));
                        break block16;
                    }
                }
                if (source.isDirectory()) {
                    c.accept(Files.newBufferedReader(source.toPath().resolve(file), StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                SanLib.LOG.log(Level.ERROR, "Error loading file: ", (Throwable)e);
            }
        }
    }

    public static Integer getInteger(String s) {
        try {
            s = s.startsWith("#") ? s.substring(1) : s;
            s = s.startsWith("0x") ? s : "0x" + s;
            long l = Long.decode(s);
            return (int)(l & 0xFFFFFFFFL);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static NumberFormat getNumberFormat(int numFract, boolean grouping, String langCode) {
        NumberFormat nf;
        if (numFract == 0) {
            nf = NumberFormat.getIntegerInstance(Locale.forLanguageTag(langCode));
        } else {
            nf = NumberFormat.getNumberInstance(Locale.forLanguageTag(langCode));
            nf.setMaximumFractionDigits(numFract);
            nf.setMinimumFractionDigits(numFract);
        }
        nf.setGroupingUsed(grouping);
        return nf;
    }

    public static String getNumberSiPrefixed(double number, int precision, String langCode) {
        for (SiPrefixes prefix : SiPrefixes.VALUES) {
            double scaledNum = number / Math.pow(10.0, prefix.exp);
            if (!(scaledNum >= 1.0)) continue;
            return MiscUtils.getNumberFormat(precision, false, langCode).format(scaledNum) + ' ' + prefix.prefix;
        }
        return MiscUtils.getNumberFormat(precision, false, langCode).format(number) + ' ';
    }

    public static ResourceLocation getPathedRL(String domain, Path root, Path file) {
        Path filePath = Paths.get(FilenameUtils.getPathNoEndSeparator((String)root.relativize(file).toString()), FilenameUtils.removeExtension((String)file.getFileName().toString()));
        return new ResourceLocation(domain, FilenameUtils.separatorsToUnix((String)filePath.toString()));
    }

    private static enum SiPrefixes {
        YOTTA("Y", 24),
        ZETTA("Z", 21),
        EXA("E", 18),
        PETA("P", 15),
        TERA("T", 12),
        GIGA("G", 9),
        MEGA("M", 6),
        KILO("k", 3),
        NONE("", 0),
        MILLI("m", -3),
        MICRO("\u00ce\u00bc", -6),
        NANO("n", -9),
        PICO("p", -12),
        FEMTO("f", -15),
        ATTO("a", -18),
        ZEPTO("z", -21),
        YOCTO("y", -24);

        public final int exp;
        public final String prefix;
        public static final SiPrefixes[] VALUES;

        private SiPrefixes(String prefix, int exp) {
            this.prefix = prefix;
            this.exp = exp;
        }

        static {
            VALUES = SiPrefixes.values();
        }
    }
}

