/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.objectweb.asm.Type;

public final class ReflectionUtils {
    private static final Map<String, Method> CACHED_METHODS = Maps.newHashMap();
    private static final Map<String, Field> CACHED_FIELDS = Maps.newHashMap();
    private static final Map<String, Constructor<?>> CACHED_CTOR = Maps.newHashMap();

    public static boolean doesClassExist(String className) {
        try {
            Class.forName(className, false, null);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError exception) {
            return false;
        }
    }

    public static <T> Class<T> getClass(String className) {
        try {
            return (Class)ReflectionUtils.getCasted(Class.forName(className));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T, E> void setCachedFieldValue(Class<? super E> classToAccess, E instance, String mcpName, String srgName, T value) {
        Field field = ReflectionUtils.getCachedField(classToAccess, mcpName, srgName);
        try {
            field.set(instance, value);
        }
        catch (Throwable exception) {
            throw new UnableToSetFieldException(exception);
        }
    }

    public static <T, E> T getCachedFieldValue(Class<? super E> classToAccess, E instance, String mcpName, String srgName) {
        Field field = ReflectionUtils.getCachedField(classToAccess, mcpName, srgName);
        try {
            return ReflectionUtils.getCasted(field.get(instance));
        }
        catch (Exception exception) {
            throw new UnableToGetFieldException(exception);
        }
    }

    public static <T, E> T invokeCachedMethod(Class<? super E> classToAccess, E instance, String mcpName, String srgName, Class<?>[] parameterTypes, Object[] parameterValues) {
        Method method = ReflectionUtils.getCachedMethod(classToAccess, mcpName, srgName, parameterTypes);
        try {
            return ReflectionUtils.getCasted(method.invoke(instance, parameterValues));
        }
        catch (Exception exception) {
            throw new UnableToInvokeMethodException(exception);
        }
    }

    public static Field getCachedField(Class<?> classToAccess, String mcpName, String srgName) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        if (CACHED_FIELDS.containsKey(key)) {
            return CACHED_FIELDS.get(key);
        }
        return ReflectionUtils.cacheAccessedField(classToAccess, mcpName, srgName);
    }

    private static Field cacheAccessedField(Class<?> classToAccess, String mcpName, String srgName) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        try {
            Field method = classToAccess.getDeclaredField(srgName);
            method.setAccessible(true);
            CACHED_FIELDS.put(key, method);
            return method;
        }
        catch (Throwable ex1) {
            try {
                Field method = classToAccess.getDeclaredField(mcpName);
                method.setAccessible(true);
                CACHED_FIELDS.put(key, method);
                return method;
            }
            catch (Throwable ex2) {
                throw new UnableToFindFieldException(ex2);
            }
        }
    }

    public static Method getCachedMethod(Class<?> classToAccess, String mcpName, String srgName, Class<?> ... parameterTypes) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        if (CACHED_METHODS.containsKey(key)) {
            return CACHED_METHODS.get(key);
        }
        return ReflectionUtils.cacheAccessedMethod(classToAccess, mcpName, srgName, parameterTypes);
    }

    private static Method cacheAccessedMethod(Class<?> classToAccess, String mcpName, String srgName, Class<?> ... parameterTypes) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        try {
            Method method = classToAccess.getDeclaredMethod(srgName, parameterTypes);
            method.setAccessible(true);
            CACHED_METHODS.put(key, method);
            return method;
        }
        catch (Throwable ex1) {
            try {
                Method method = classToAccess.getDeclaredMethod(mcpName, parameterTypes);
                method.setAccessible(true);
                CACHED_METHODS.put(key, method);
                return method;
            }
            catch (Throwable ex2) {
                throw new UnableToFindMethodException(ex2);
            }
        }
    }

    public static Object getNew(String classToAccess, Class<?>[] parameterTypes, Object ... parameters) {
        String key = classToAccess + '_' + String.join((CharSequence)"", (CharSequence[])Arrays.stream(parameterTypes).map(Type::getDescriptor).toArray(String[]::new));
        Constructor<?> c = CACHED_CTOR.containsKey(key) ? CACHED_CTOR.get(key) : ReflectionUtils.cacheAccessedConstructor(classToAccess, parameterTypes);
        try {
            return c.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnableToInstantiateException(e);
        }
    }

    private static Constructor<?> cacheAccessedConstructor(String classToAccess, Class<?> ... parameterTypes) {
        String key = classToAccess + '_' + String.join((CharSequence)"", (CharSequence[])Arrays.stream(parameterTypes).map(Type::getDescriptor).toArray(String[]::new));
        try {
            Class<?> clazz = Class.forName(classToAccess);
            Constructor<?> ctor = clazz.getDeclaredConstructor(parameterTypes);
            ctor.setAccessible(true);
            CACHED_CTOR.put(key, ctor);
            return ctor;
        }
        catch (Throwable ex) {
            throw new UnableToAccessCtorException(ex);
        }
    }

    public static <T> T getCasted(Object obj) {
        return (T)obj;
    }

    public static class UnableToInstantiateException
    extends RuntimeException {
        private static final long serialVersionUID = -8782108462439942148L;

        public UnableToInstantiateException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToAccessCtorException
    extends RuntimeException {
        private static final long serialVersionUID = -8782108462439942148L;

        public UnableToAccessCtorException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private static final long serialVersionUID = -8782108462439942148L;

        public UnableToFindFieldException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        private static final long serialVersionUID = -8564063759409317615L;

        public UnableToFindMethodException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToInvokeMethodException
    extends RuntimeException {
        private static final long serialVersionUID = -784953849174764940L;

        public UnableToInvokeMethodException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToGetFieldException
    extends RuntimeException {
        private static final long serialVersionUID = -4541085527693869891L;

        public UnableToGetFieldException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToSetFieldException
    extends RuntimeException {
        private static final long serialVersionUID = -9156919529246923057L;

        public UnableToSetFieldException(Throwable exception) {
            super(exception);
        }
    }
}

