/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util;

import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class UuidUtils {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private static final Pattern UUID_PTRN = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-4[a-f0-9]{3}-[89ab][a-f0-9]{3}-[a-f0-9]{12}", 2);

    public static boolean isStringUuid(String uuid) {
        return UUID_PTRN.matcher(uuid).matches();
    }

    public static boolean areUuidsEqual(Object uuid1, Object uuid2) {
        UUID uuidInst2;
        Function<Object, UUID> getUUID = obj -> {
            if (obj instanceof String && UuidUtils.isStringUuid(obj.toString())) {
                return UUID.fromString(obj.toString());
            }
            if (obj instanceof UUID) {
                return (UUID)obj;
            }
            if (obj instanceof byte[]) {
                return UUID.nameUUIDFromBytes((byte[])obj);
            }
            return null;
        };
        UUID uuidInst1 = getUUID.apply(uuid1);
        return uuidInst1 == (uuidInst2 = getUUID.apply(uuid2)) || uuidInst1 != null && uuidInst1.equals(uuidInst2);
    }
}

