/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util.config;

import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.lib.util.config.Category;
import de.sanandrew.mods.sanlib.lib.util.config.EnumExclude;
import de.sanandrew.mods.sanlib.lib.util.config.Init;
import de.sanandrew.mods.sanlib.lib.util.config.Value;
import de.sanandrew.mods.sanlib.lib.util.config.type.IValueType;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeArrayBoolean;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeArrayDouble;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeArrayInteger;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeArrayString;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeBoolean;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeFloatingPoint;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeInteger;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeLong;
import de.sanandrew.mods.sanlib.lib.util.config.type.ValueTypeString;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class ConfigUtils {
    public static final List<IValueType> TYPE_LIST = new ArrayList<IValueType>(){
        {
            this.add(new ValueTypeInteger());
            this.add(new ValueTypeFloatingPoint());
            this.add(new ValueTypeBoolean());
            this.add(new ValueTypeString());
            this.add(new ValueTypeArrayInteger());
            this.add(new ValueTypeArrayDouble());
            this.add(new ValueTypeArrayBoolean());
            this.add(new ValueTypeArrayString());
            this.add(new ValueTypeLong());
        }
    };
    private static final Map<String, Object> DEFAULTS = new HashMap<String, Object>();

    public static Configuration loadConfigFile(File cfgFile, String version, String modName) {
        Configuration config = new Configuration(cfgFile, version, true);
        String loadedVer = config.getLoadedConfigVersion();
        if (loadedVer != null && Integer.parseInt(loadedVer.split("\\.")[0]) < Integer.parseInt(version.split("\\.")[0])) {
            try {
                FileUtils.copyFile((File)cfgFile, (File)new File(cfgFile.getAbsoluteFile() + ".old"));
                config.getCategoryNames().forEach(cat -> config.removeCategory(config.getCategory(cat)));
                SanLib.LOG.log(Level.WARN, String.format("%s config file is too outdated! Config will be overwritten - the old config file can be found at %s.old", modName, cfgFile.getAbsoluteFile()));
            }
            catch (IOException ex) {
                SanLib.LOG.log(Level.ERROR, String.format("%s config file is too outdated but cannot be updated! This will cause errors! Please copy the old config somewhere and remove it from the config folder!", modName), (Throwable)ex);
            }
        }
        return config;
    }

    public static void loadCategories(Configuration config, Class<?> base) {
        ConfigUtils.invokeInit(base, Init.Stage.PRE);
        ConfigUtils.loadCategories(config, base, null);
        ConfigUtils.invokeInit(base, Init.Stage.POST);
    }

    private static void loadCategories(Configuration config, Class<?> base, String prefix) {
        for (Class<?> c : base.getDeclaredClasses()) {
            ConfigUtils.loadCategory(config, c, prefix);
        }
    }

    private static void invokeInit(Class<?> base, Init.Stage stage) {
        if (!base.isEnum()) {
            try {
                Method init = Arrays.stream(base.getMethods()).filter(m -> {
                    Init a = m.getAnnotation(Init.class);
                    return a != null && a.value() == stage;
                }).findFirst().orElseGet(() -> ConfigUtils.getOldInit(base));
                if (init != null) {
                    init.invoke(null, new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                SanLib.LOG.log(Level.WARN, String.format("Could not call initializer in class %s", base.getName()), (Throwable)ex);
            }
        }
    }

    @Deprecated
    private static Method getOldInit(Class<?> c) {
        try {
            return c.getMethod("init", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void loadCategory(Configuration config, Class<?> c, String prefix) {
        Category cat = c.getAnnotation(Category.class);
        ConfigUtils.loadCategory(config, c, prefix, cat, null);
    }

    private static <E> void loadCategory(Configuration config, Class<? extends E> c, String prefix, Category cat, E enumInst) {
        if (cat != null) {
            String qualifiedName = prefix != null ? prefix + "." + cat.value() : cat.value();
            ConfigCategory cCat = config.getCategory(qualifiedName);
            if (!cat.inherit()) {
                cCat.setComment(cat.comment());
                cCat.setRequiresMcRestart(cat.reqMcRestart());
                cCat.setRequiresWorldRestart(cat.reqWorldRestart());
            }
            if (c.isEnum()) {
                if (enumInst != null) {
                    ConfigUtils.loadValues(config, qualifiedName, c, enumInst);
                } else {
                    for (final Field f : c.getDeclaredFields()) {
                        if (!f.isEnumConstant() || f.getAnnotation(EnumExclude.class) != null) continue;
                        try {
                            Category catInner = new Category(){
                                private final String name;
                                {
                                    this.name = f.getName().toLowerCase(Locale.ROOT);
                                }

                                @Override
                                public Class<? extends Annotation> annotationType() {
                                    return Category.class;
                                }

                                @Override
                                public String value() {
                                    return this.name;
                                }

                                @Override
                                public String comment() {
                                    return "";
                                }

                                @Override
                                public boolean reqMcRestart() {
                                    return false;
                                }

                                @Override
                                public boolean reqWorldRestart() {
                                    return false;
                                }

                                @Override
                                public boolean inherit() {
                                    return true;
                                }
                            };
                            ConfigUtils.loadCategory(config, c, qualifiedName, catInner, f.get(null));
                        }
                        catch (IllegalAccessException ex) {
                            SanLib.LOG.log(Level.ERROR, String.format("Could not load config value for enum value %s in enum %s", f.getName(), f.getDeclaringClass().getName()), (Throwable)ex);
                        }
                    }
                }
            } else {
                ConfigUtils.invokeInit(c, Init.Stage.PRE);
                ConfigUtils.loadCategories(config, c, qualifiedName);
                ConfigUtils.loadValues(config, qualifiedName, c);
                ConfigUtils.invokeInit(c, Init.Stage.POST);
            }
        }
    }

    private static void loadValues(Configuration config, String catName, Class<?> c) {
        ConfigUtils.loadValues(config, catName, c, null);
    }

    private static void loadValues(Configuration config, String catName, Class<?> c, Object inst) {
        for (Field f : c.getDeclaredFields()) {
            Value val = f.getAnnotation(Value.class);
            try {
                if (val == null) continue;
                f.setAccessible(true);
                Class<?> cv = f.getType();
                String name = val.value().isEmpty() ? f.getName() : val.value();
                String category = val.category().isEmpty() ? catName : val.category();
                String defKey = ConfigUtils.getDefaultKey(config, category, name);
                boolean parsed = false;
                for (IValueType type : TYPE_LIST) {
                    if (!type.typeFits(cv)) continue;
                    if (!DEFAULTS.containsKey(defKey)) {
                        DEFAULTS.put(defKey, type.getDefaultValue(cv, f, inst));
                    }
                    Object def = DEFAULTS.get(defKey);
                    Property p = type.getProperty(config, category, name, def, val.comment(), val.range());
                    p.setRequiresMcRestart(val.reqMcRestart());
                    p.setRequiresWorldRestart(val.reqWorldRestart());
                    type.setValue(cv, f, inst, p, def, val.range());
                    parsed = true;
                    break;
                }
                if (parsed) continue;
                SanLib.LOG.log(Level.ERROR, String.format("The type %s of field %s in class %s is not supported! Please register a custom value parser in ConfigUtils.TYPE_LIST.", cv.getName(), f.getName(), f.getDeclaringClass().getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(String.format("Could not load config value for field %s in class %s", f.getName(), f.getDeclaringClass().getName()), ex);
            }
        }
    }

    private static String getDefaultKey(Configuration config, String cat, String val) {
        return config.toString() + "." + config.getCategory(cat).getQualifiedName() + "." + val;
    }
}

