/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util.config.type;

import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.type.IValueType;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ValueTypeFloatingPoint
implements IValueType {
    @Override
    public boolean typeFits(Class<?> type) {
        return type == Float.TYPE || type == Double.TYPE;
    }

    @Override
    public Object getDefaultValue(Class<?> type, Field f, Object instance) throws IllegalAccessException, IllegalArgumentException {
        return type == Float.TYPE ? Double.valueOf(Float.valueOf(f.getFloat(instance)).toString()).doubleValue() : f.getDouble(instance);
    }

    @Override
    public Property getProperty(Configuration config, String category, String name, Object defaultVal, String propComment, Range propRange) {
        double min = propRange.minD();
        double max = propRange.maxD();
        StringBuilder comment = new StringBuilder(propComment);
        if (min == -1.7976931348623157E308) {
            if (max == Double.MAX_VALUE) {
                comment.append(" [default: ").append(defaultVal).append(']');
            } else {
                comment.append(" [maximum: ").append(max).append(", default: ").append(defaultVal).append(']');
            }
        } else if (max == Double.MAX_VALUE) {
            comment.append(" [minimum: ").append(min).append(", default: ").append(defaultVal).append(']');
        } else {
            comment.append(" [range: ").append(min).append(" ~ ").append(max).append(", default: ").append(defaultVal).append(']');
        }
        return config.get(category, name, ((Double)defaultVal).doubleValue(), comment.toString().trim(), min, max);
    }

    @Override
    public void setValue(Class<?> type, Field f, Object instance, Property p, Object defaultVal, Range propRange) throws IllegalAccessException, IllegalArgumentException {
        double d = p.getDouble();
        if (d < propRange.minD() || d > propRange.maxD()) {
            throw new IllegalArgumentException(String.format("The property %s does not fall within range!", p.getName()));
        }
        if (type == Float.TYPE) {
            f.setFloat(instance, (float)d);
        } else {
            f.setDouble(instance, d);
        }
    }
}

