/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.lib.util.config.type;

import de.sanandrew.mods.sanlib.lib.util.config.Range;
import de.sanandrew.mods.sanlib.lib.util.config.type.IValueType;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ValueTypeLong
implements IValueType {
    @Override
    public boolean typeFits(Class<?> type) {
        return type == Long.TYPE;
    }

    @Override
    public Object getDefaultValue(Class<?> type, Field f, Object instance) throws IllegalAccessException, IllegalArgumentException {
        return f.getLong(instance);
    }

    @Override
    public Property getProperty(Configuration config, String category, String name, Object defaultVal, String propComment, Range propRange) {
        long min = propRange.minL();
        long max = propRange.maxL();
        long dvl = (Long)defaultVal;
        StringBuilder comment = new StringBuilder(propComment);
        if (min == Long.MIN_VALUE) {
            if (max == Long.MAX_VALUE) {
                comment.append(" [default: ").append(defaultVal).append(']');
            } else {
                comment.append(" [maximum: ").append(max).append(", default: ").append(defaultVal).append(']');
            }
        } else if (max == Long.MAX_VALUE) {
            comment.append(" [minimum: ").append(min).append(", default: ").append(defaultVal).append(']');
        } else {
            comment.append(" [range: ").append(min).append(" ~ ").append(max).append(", default: ").append(defaultVal).append(']');
        }
        Property prop = config.get(category, name, Long.toString(dvl), comment.toString().trim(), Property.Type.DOUBLE);
        prop.setDefaultValue(Long.toString(dvl));
        prop.setMinValue((double)min);
        prop.setMaxValue((double)max);
        if (!prop.isLongValue()) {
            prop.setValue((double)dvl);
        }
        return prop;
    }

    @Override
    public void setValue(Class<?> type, Field f, Object instance, Property p, Object defaultVal, Range propRange) throws IllegalAccessException, IllegalArgumentException {
        long i = p.getLong();
        if (i < propRange.minL() || i > propRange.maxL()) {
            throw new IllegalArgumentException(String.format("The property %s does not fall within range!", p.getName()));
        }
        if (type == Long.TYPE) {
            f.setLong(instance, i);
        }
    }
}

