/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.sanplayermodel.client.renderer.entity.layers;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.sanplayermodel.SanPlayerModel;
import de.sanandrew.mods.sanlib.sanplayermodel.client.model.ModelSanSkirt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class LayerSanSkirt
implements LayerRenderer<EntityPlayer> {
    protected final RenderPlayer renderPlayer;
    private final ModelSanSkirt skirt = new ModelSanSkirt(0.0f);
    private final ModelSanSkirt skirtArmor = new ModelSanSkirt(0.5f);
    private final Map<Item, ResourceLocation> skirtArmorList = new HashMap<Item, ResourceLocation>();
    private final Map<Item, ResourceLocation> skirtArmorOverlays = new HashMap<Item, ResourceLocation>();

    public LayerSanSkirt(RenderPlayer renderPlayer) {
        this.renderPlayer = renderPlayer;
    }

    public void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (SanPlayerModel.isSanPlayer(player)) {
            ItemStack pants = player.func_184582_a(EntityEquipmentSlot.LEGS);
            boolean hasPants = ItemStackUtils.isValid(pants);
            if (!hasPants || this.hasSkirtArmor(pants)) {
                LayerSanSkirt.renderSkirt(this.skirt, this.renderPlayer, false, null, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
            if (hasPants) {
                ResourceLocation rl;
                Item pantsItem = pants.func_77973_b();
                boolean test = false;
                Integer overlay = null;
                if (pantsItem instanceof ItemArmor && ((ItemArmor)pantsItem).hasOverlay(pants)) {
                    overlay = ((ItemArmor)pantsItem).func_82814_b(pants);
                }
                if (!this.skirtArmorList.containsKey(pantsItem)) {
                    String path = String.format("textures/entity/player/%s", MiscUtils.applyNonNull(pants.func_77973_b().getRegistryName(), ResourceLocation::toString, "").replace(":", "_"));
                    this.skirtArmorList.put(pantsItem, new ResourceLocation("sanplayermodel", path + ".png"));
                    test = true;
                    if (overlay != null) {
                        this.skirtArmorOverlays.put(pantsItem, new ResourceLocation("sanplayermodel", path + "_overlay.png"));
                    }
                }
                if ((rl = this.skirtArmorList.get(pants.func_77973_b())) != null) {
                    try {
                        if (test) {
                            Minecraft.func_71410_x().func_110442_L().func_110536_a(rl);
                        }
                        this.skirtArmor.setTexture(rl);
                        LayerSanSkirt.renderSkirt(this.skirtArmor, this.renderPlayer, pants.func_77948_v(), overlay, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                        if (this.skirtArmorOverlays.containsKey(pantsItem)) {
                            this.skirtArmor.setTexture(this.skirtArmorOverlays.get(pantsItem));
                            LayerSanSkirt.renderSkirt(this.skirtArmor, this.renderPlayer, pants.func_77948_v(), null, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                        }
                    }
                    catch (IOException ex) {
                        SanPlayerModel.LOG.log(Level.WARN, String.format("Cannot find texture for %s", rl));
                        this.skirtArmorList.put(pantsItem, null);
                    }
                }
            }
        }
    }

    private boolean hasSkirtArmor(ItemStack pants) {
        return this.skirtArmorList.get(pants.func_77973_b()) != null;
    }

    private static void renderSkirt(ModelSanSkirt skirt, RenderPlayer renderPlayer, boolean glint, Integer overlay, EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        skirt.func_178686_a((ModelBase)renderPlayer.func_177087_b());
        if (overlay != null) {
            float red = (float)(overlay >> 16 & 0xFF) / 255.0f;
            float green = (float)(overlay >> 8 & 0xFF) / 255.0f;
            float blue = (float)(overlay & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        renderPlayer.func_110776_a(skirt.getTexture());
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        renderPlayer.func_177087_b().field_78115_e.func_78794_c(0.0625f);
        skirt.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)player);
        skirt.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (glint) {
            LayerArmorBase.func_188364_a((RenderLivingBase)renderPlayer, (EntityLivingBase)player, (ModelBase)skirt, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }
}

