/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.InventoryPets;
import com.inventorypets.ModSoundEvents;
import com.inventorypets.entities.EntityQuantumFireball;
import com.inventorypets.entities.EntityQuantumMob;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMiniQuantumBlaze
extends EntityQuantumMob {
    private float heightOffset = -1.0f;
    private int heightOffsetUpdateTime;
    private int field_70846_g;
    private int miniCount = 1800;
    private int attackTime;
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(EntityBlaze.class, (DataSerializer)DataSerializers.field_187191_a);
    private boolean hasAttacked = false;

    public EntityMiniQuantumBlaze(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFireballAttack());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9000000417232513);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 6.0f);
    }

    protected SoundEvent getLivingSound() {
        return ModSoundEvents.mqbbreathe;
    }

    protected SoundEvent getHurtSound() {
        return ModSoundEvents.mqbhit;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.mqbdeath;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    public float getBrightness(float par1) {
        return 2.0f;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 100.0);
            if (entityplayer != null) {
                if (Math.abs(entityplayer.field_70165_t - this.field_70165_t) + Math.abs(entityplayer.field_70163_u - this.field_70163_u) + Math.abs(entityplayer.field_70161_v - this.field_70161_v) >= 24.0) {
                    this.func_70091_d(MoverType.PLAYER, entityplayer.field_70165_t - this.field_70165_t, entityplayer.field_70163_u - this.field_70163_u, entityplayer.field_70161_v - this.field_70161_v);
                }
                if (entityplayer.func_110144_aD() != null) {
                    this.func_70624_b(entityplayer.func_110144_aD());
                } else if (entityplayer.func_110144_aD() == null) {
                    this.func_70624_b(entityplayer.func_70643_av());
                }
            }
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = -0.5f + (float)this.field_70146_Z.nextGaussian() * 2.0f;
            }
            if (this.func_70638_az() != null && this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            }
        }
        if (this.field_70146_Z.nextInt(24) == 0) {
            // empty if block
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.3;
        }
        if (this.field_70170_p.field_72995_K) {
            InventoryPets.proxy.spawnPortalEffects2(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        --this.miniCount;
        if (this.miniCount <= 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.mqbdeath, SoundCategory.PLAYERS, 0.8f, 1.0f);
            this.func_70106_y();
        }
        super.func_70636_d();
    }

    protected void attackEntity(Entity par1Entity, float par2) {
        if (this.attackTime <= 0 && par2 < 2.0f && par1Entity.func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && par1Entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
            this.attackTime = 2;
            this.func_70652_k(par1Entity);
        } else if (par2 < 30.0f) {
            double d0 = par1Entity.field_70165_t - this.field_70165_t;
            double d1 = par1Entity.func_174813_aQ().field_72338_b + (double)(par1Entity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = par1Entity.field_70161_v - this.field_70161_v;
            if (this.attackTime == 0) {
                ++this.field_70846_g;
                if (this.field_70846_g == 1) {
                    this.attackTime = 5;
                    this.setOnFire(true);
                } else if (this.field_70846_g <= 4) {
                    this.attackTime = 3;
                } else {
                    this.attackTime = 10;
                    this.field_70846_g = 0;
                    this.setOnFire(false);
                }
                if (this.field_70846_g > 1) {
                    float f1 = MathHelper.func_76129_c((float)par2) * 0.5f;
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1009, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
                    for (int i = 0; i < 1; ++i) {
                        EntityQuantumFireball entityquantumfireball = new EntityQuantumFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                        entityquantumfireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                        this.field_70170_p.func_72838_d((Entity)entityquantumfireball);
                    }
                }
            }
            this.field_70181_x = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }

    protected void fall(float par1) {
    }

    protected Item func_146068_u() {
        return Items.field_191525_da;
    }

    public boolean func_70027_ad() {
        return this.isCharged();
    }

    protected void func_70628_a(boolean par1, int par2) {
        int h = this.field_70146_Z.nextInt(100);
        if (h >= 2 && h <= 20) {
            this.func_145779_a(InventoryPets.nuggetCoal, 1);
        } else if (h == 1) {
            this.func_145779_a(InventoryPets.nuggetDiamond, 1);
        }
    }

    public boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    public void setOnFire(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)b0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    class AIFireballAttack
    extends EntityAIBase {
        private EntityMiniQuantumBlaze blaze;
        private int attackStep;
        private int attackTime;
        private static final String __OBFID = "CL_00002225";

        public AIFireballAttack() {
            this.blaze = EntityMiniQuantumBlaze.this;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.blaze.setOnFire(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            double d0 = this.blaze.func_70068_e((Entity)entitylivingbase);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blaze.func_70652_k((Entity)entitylivingbase);
                }
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            } else if (d0 < 256.0) {
                double d1 = entitylivingbase.field_70165_t - this.blaze.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - this.blaze.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 10;
                        this.blaze.setOnFire(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 20;
                        this.attackStep = 0;
                        this.blaze.setOnFire(false);
                    }
                    if (this.attackStep > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        this.blaze.field_70170_p.func_180498_a((EntityPlayer)null, 1009, new BlockPos((int)this.blaze.field_70165_t, (int)this.blaze.field_70163_u, (int)this.blaze.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.blaze.field_70170_p, (EntityLivingBase)this.blaze, d1 + this.blaze.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.blaze.func_70681_au().nextGaussian() * (double)f);
                            entitysmallfireball.field_70163_u = this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 2.0f) + 0.5;
                            this.blaze.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                        }
                    }
                }
                this.blaze.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            } else {
                this.blaze.func_70661_as().func_75499_g();
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }
    }
}

