/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config.custom;

import java.util.EnumSet;
import java.util.Optional;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.control.GuiSlider;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntryValueBackpackSize
extends GuiSlider
implements IConfigValue<BackpackSize> {
    public EntryValueBackpackSize() {
        super(200, 0, EnumSet.allOf(Direction.class));
        this.setRangeX(BackpackSize.MIN.getColumns(), BackpackSize.MAX.getColumns());
        this.setRangeY(BackpackSize.MIN.getRows(), BackpackSize.MAX.getRows());
        this.setStepSize(1.0);
        this.setSliderSize(16);
    }

    @Override
    public Optional<BackpackSize> getValue() {
        return Optional.of(new BackpackSize((int)this.getSliderValueX(), (int)this.getSliderValueY()));
    }

    @Override
    public void setValue(BackpackSize value) {
        this.setSliderValue(value.getColumns(), (double)value.getRows());
    }

    @Override
    public String getValueText() {
        return this.getValue().get().toString();
    }

    @Override
    public void onSizeChanged(Direction direction) {
        this.setHeight(this.getWidth() * BackpackSize.MAX.getRows() / BackpackSize.MAX.getColumns());
    }
}

