/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.control;

import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiButton
extends GuiElementBase {
    public static final ResourceLocation BUTTON_TEX = new ResourceLocation("textures/gui/widgets.png");
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 20;
    public static final int MIN_TEXT_PADDING = 6;
    public static final int DEFAULT_TEXT_PADDING = 20;
    private String _text = "";
    private int _textColor = -1;
    private Runnable _action = null;
    private boolean _isSwitch = false;
    private boolean _switchOn = false;

    public GuiButton() {
        this(200);
    }

    public GuiButton(int width) {
        this(width, 20);
    }

    public GuiButton(int width, int height) {
        this(width, height, "");
    }

    public GuiButton(String text) {
        this(GuiButton.getStringWidth(text) + 20, text);
    }

    public GuiButton(int width, String text) {
        this(width, 20, text);
    }

    public GuiButton(int width, int height, String text) {
        this(0, 0, width, height, text);
    }

    public GuiButton(int x, int y, int width, int height, String text) {
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setText(text);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String value) {
        if (value == null) {
            throw new NullPointerException("Argument can't be null");
        }
        this._text = value;
    }

    public final void addText(String value) {
        if (value == null) {
            throw new NullPointerException("Argument can't be null");
        }
        this.setText(this.getText() + value);
    }

    public int getTextColor() {
        return this.getTextColor(false);
    }

    public int getTextColor(boolean isHighlighted) {
        return this._textColor >= 0 ? this._textColor : (!this.isEnabled() ? -6250336 : (isHighlighted ? -96 : -2039584));
    }

    public final void unsetTextColor() {
        this.setTextColor(-1);
    }

    public void setTextColor(int value) {
        this._textColor = value;
    }

    public boolean isSwitch() {
        return this._isSwitch;
    }

    public boolean isSwitchOn() {
        return this._switchOn;
    }

    public void setSwitch() {
        this.setSwitch(false);
    }

    public void setSwitch(boolean value) {
        this._isSwitch = true;
        this._switchOn = value;
    }

    public void setAction(Runnable value) {
        this._action = value;
    }

    @Override
    public boolean canPress() {
        return true;
    }

    @Override
    public void onPressed(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            return;
        }
        this.playPressSound();
        if (this.isSwitch()) {
            this.setSwitch(!this.isSwitchOn());
        }
        if (this._action != null) {
            this._action.run();
        }
    }

    public void playPressSound() {
        GuiButton.getMC().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        boolean isHighlighted = this.isHighlighted(mouseX, mouseY);
        if (this.isSwitchOn()) {
            GlStateManager.func_179129_p();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)this.getHeight(), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            this.drawButtonBackground(isHighlighted, partialTicks);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            this.drawButtonForeground(isHighlighted, partialTicks);
            GlStateManager.func_179121_F();
        } else {
            this.drawButtonBackground(isHighlighted, partialTicks);
            this.drawButtonForeground(isHighlighted, partialTicks);
        }
    }

    protected void drawButtonBackground(boolean isHighlighted, float partialTicks) {
        int buttonIndex = !this.isEnabled() ? 0 : (!isHighlighted ? 1 : 2);
        int ty = 46 + buttonIndex * 20;
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)BUTTON_TEX, (int)0, (int)0, (int)0, (int)ty, (int)this.getWidth(), (int)this.getHeight(), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)0.0f);
    }

    protected void drawButtonForeground(boolean isHighlighted, float partialTicks) {
        int maxTextWidth;
        String text = this.getText();
        if (text.isEmpty()) {
            return;
        }
        FontRenderer fontRenderer = GuiButton.getFontRenderer();
        int textWidth = fontRenderer.func_78256_a(text);
        if (textWidth > (maxTextWidth = this.getWidth() - 6) && textWidth > ELLIPSIS_WIDTH) {
            text = fontRenderer.func_78269_a(text, maxTextWidth - ELLIPSIS_WIDTH).trim() + "...";
            textWidth = fontRenderer.func_78256_a(text);
        }
        fontRenderer.func_175063_a(text, (float)(this.getWidth() / 2 - textWidth / 2), (float)((this.getHeight() - 8) / 2), this.getTextColor(isHighlighted));
    }
}

