/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CycleTimer {
    private static final int cycleTime = 1000;
    private long startTime;
    private long drawTime;
    private long pausedDuration = 0L;

    public CycleTimer(int offset) {
        if (offset == -1) {
            offset = (int)(Math.random() * 10000.0);
        }
        long time = System.currentTimeMillis();
        this.startTime = time - (long)(offset * 1000);
        this.drawTime = time;
    }

    @Nullable
    public <T> T getCycledItem(Collection<T> list) {
        return this.getCycledItem((List<T>)new ArrayList<T>(list));
    }

    @Nullable
    public <T> T getCycledItem(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        Long index = (this.drawTime - this.startTime) / 1000L % (long)list.size();
        return list.get(index.intValue());
    }

    public void onDraw() {
        if (!GuiScreen.func_146272_n()) {
            if (this.pausedDuration > 0L) {
                this.startTime += this.pausedDuration;
                this.pausedDuration = 0L;
            }
            this.drawTime = System.currentTimeMillis();
        } else {
            this.pausedDuration = System.currentTimeMillis() - this.drawTime;
        }
    }
}

