/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.model;

import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public final class Model3DTexture
extends ModelBox {
    private final int width;
    private final int height;
    private final float u1;
    private final float v1;
    private final float u2;
    private final float v2;

    private Model3DTexture(ModelRenderer model, float posX, float posY, float posZ, int width, int height, float u1, float v1, float u2, float v2) {
        super(model, 0, 0, posX, posY, posZ, 0, 0, 0, 0.0f);
        this.width = width;
        this.height = height;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void func_178780_a(BufferBuilder buf, float scale) {
        float f9;
        float f8;
        float f82;
        float f7;
        int k;
        Tessellator tessellator = Tessellator.func_178181_a();
        float x0 = this.field_78252_a * scale;
        float x1 = (this.field_78252_a + (float)this.width) * scale;
        float y0 = this.field_78250_b * scale;
        float y1 = (this.field_78250_b + (float)this.height) * scale;
        float z0 = this.field_78251_c * scale;
        float z1 = (this.field_78251_c + 1.0f) * scale;
        buf.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        buf.func_181662_b((double)x1, (double)y0, (double)z0).func_187315_a((double)this.u2, (double)this.v1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buf.func_181662_b((double)x0, (double)y0, (double)z0).func_187315_a((double)this.u1, (double)this.v1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buf.func_181662_b((double)x0, (double)y1, (double)z0).func_187315_a((double)this.u1, (double)this.v2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buf.func_181662_b((double)x1, (double)y1, (double)z0).func_187315_a((double)this.u2, (double)this.v2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buf.func_181662_b((double)x1, (double)y1, (double)z1).func_187315_a((double)this.u2, (double)this.v2).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buf.func_181662_b((double)x0, (double)y1, (double)z1).func_187315_a((double)this.u1, (double)this.v2).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buf.func_181662_b((double)x0, (double)y0, (double)z1).func_187315_a((double)this.u1, (double)this.v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buf.func_181662_b((double)x1, (double)y0, (double)z1).func_187315_a((double)this.u2, (double)this.v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        float f5 = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float f6 = 0.5f * (this.v1 - this.v2) / (float)this.height;
        for (k = 0; k < this.width; ++k) {
            f7 = x0 + (float)k * scale;
            f82 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            buf.func_181662_b((double)f7, (double)y0, (double)z0).func_187315_a((double)f82, (double)this.v1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)f7, (double)y0, (double)z1).func_187315_a((double)f82, (double)this.v1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)f7, (double)y1, (double)z1).func_187315_a((double)f82, (double)this.v2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)f7, (double)y1, (double)z0).func_187315_a((double)f82, (double)this.v2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        for (k = 0; k < this.width; ++k) {
            f8 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            f9 = x0 + (float)(k + 1) * scale;
            buf.func_181662_b((double)f9, (double)y1, (double)z0).func_187315_a((double)f8, (double)this.v2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)f9, (double)y1, (double)z1).func_187315_a((double)f8, (double)this.v2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)f9, (double)y0, (double)z1).func_187315_a((double)f8, (double)this.v1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)f9, (double)y0, (double)z0).func_187315_a((double)f8, (double)this.v1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        }
        for (k = 0; k < this.height; ++k) {
            f8 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            f9 = y0 + (float)(k + 1) * scale;
            buf.func_181662_b((double)x1, (double)f9, (double)z0).func_187315_a((double)this.u2, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)x0, (double)f9, (double)z0).func_187315_a((double)this.u1, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)x0, (double)f9, (double)z1).func_187315_a((double)this.u1, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)x1, (double)f9, (double)z1).func_187315_a((double)this.u2, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        for (k = 0; k < this.height; ++k) {
            f7 = y0 + (float)k * scale;
            f82 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            buf.func_181662_b((double)x0, (double)f7, (double)z0).func_187315_a((double)this.u1, (double)f82).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)x1, (double)f7, (double)z0).func_187315_a((double)this.u2, (double)f82).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)x1, (double)f7, (double)z1).func_187315_a((double)this.u2, (double)f82).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_181662_b((double)x0, (double)f7, (double)z1).func_187315_a((double)this.u1, (double)f82).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static Model3DTexture create(ModelRenderer model, float posX, float posY, float posZ, int width, int height, int u, int v) {
        return new Model3DTexture(model, posX, posY, posZ, width, height, (float)u / model.field_78801_a, (float)v / model.field_78799_b, (float)(u + width) / model.field_78801_a, (float)(v + height) / model.field_78799_b);
    }
}

