/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;

public interface Flight {
    default public void setIsFlying(boolean isFlying) {
        this.setIsFlying(isFlying, PlayerSet.empty());
    }

    public void setIsFlying(boolean var1, PlayerSet var2);

    public boolean isFlying();

    default public void toggleIsFlying(PlayerSet players) {
        this.setIsFlying(!this.isFlying(), players);
    }

    public void setTimeFlying(int var1);

    public int getTimeFlying();

    public float getFlyingAmount(float var1);

    public void registerFlyingListener(FlyingListener var1);

    public void registerSyncListener(SyncListener var1);

    public boolean canFly(EntityPlayer var1);

    public boolean canLand(EntityPlayer var1, ItemStack var2);

    public void tick(EntityPlayer var1, ItemStack var2);

    public void onFlown(EntityPlayer var1, ItemStack var2, Vec3d var3);

    public void clone(Flight var1);

    public void sync(PlayerSet var1);

    public void serialize(PacketBuffer var1);

    public void deserialize(PacketBuffer var1);

    public static interface Notifier {
        public void notifySelf();

        public void notifyPlayer(EntityPlayerMP var1);

        public void notifyOthers();

        public static Notifier of(final Runnable notifySelf, final Consumer<EntityPlayerMP> notifyPlayer, final Runnable notifyOthers) {
            return new Notifier(){

                @Override
                public void notifySelf() {
                    notifySelf.run();
                }

                @Override
                public void notifyPlayer(EntityPlayerMP player) {
                    notifyPlayer.accept(player);
                }

                @Override
                public void notifyOthers() {
                    notifyOthers.run();
                }
            };
        }
    }

    public static interface PlayerSet {
        public void notify(Notifier var1);

        public static PlayerSet empty() {
            return n -> {};
        }

        public static PlayerSet ofSelf() {
            return Notifier::notifySelf;
        }

        public static PlayerSet ofPlayer(EntityPlayerMP player) {
            return n -> n.notifyPlayer(player);
        }

        public static PlayerSet ofOthers() {
            return Notifier::notifyOthers;
        }

        public static PlayerSet ofAll() {
            return n -> {
                n.notifySelf();
                n.notifyOthers();
            };
        }
    }

    public static interface SyncListener {
        public void onSync(PlayerSet var1);

        public static Consumer<SyncListener> onSyncUsing(PlayerSet players) {
            return l -> l.onSync(players);
        }
    }

    public static interface FlyingListener {
        public void onChange(boolean var1);

        public static Consumer<FlyingListener> onChangeUsing(boolean isFlying) {
            return l -> l.onChange(isFlying);
        }
    }
}

