/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.world.feature;

import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public final class FeatureVein
extends WorldGenerator {
    private final UnaryOperator<IBlockState> block;
    private final int size;
    private final Predicate<IBlockState> canReplace;

    public FeatureVein(Supplier<IBlockState> block, int size) {
        this(b -> (IBlockState)block.get(), size);
    }

    public FeatureVein(UnaryOperator<IBlockState> block, int size) {
        this(block, size, StonePredicate.create());
    }

    public FeatureVein(UnaryOperator<IBlockState> block, int size, Predicate<IBlockState> canReplace) {
        this.block = block;
        this.size = size;
        this.canReplace = canReplace;
    }

    public boolean func_180709_b(World world, Random rng, BlockPos pos) {
        float yaw = rng.nextFloat() * (float)Math.PI;
        double xExtent = MathHelper.func_76126_a((float)yaw) * (float)this.size / 8.0f;
        double zExtent = MathHelper.func_76134_b((float)yaw) * (float)this.size / 8.0f;
        double startX = (double)pos.func_177958_n() + xExtent;
        double endX = (double)pos.func_177958_n() - xExtent;
        double startZ = (double)pos.func_177952_p() + zExtent;
        double endZ = (double)pos.func_177952_p() - zExtent;
        double startY = pos.func_177956_o() + rng.nextInt(3) - 2;
        double endY = pos.func_177956_o() + rng.nextInt(3) - 2;
        for (int n = 0; n < this.size; ++n) {
            float delta = (float)n / (float)this.size;
            double x = startX + (endX - startX) * (double)delta;
            double y = startY + (endY - startY) * (double)delta;
            double z = startZ + (endZ - startZ) * (double)delta;
            double girth = rng.nextDouble() * (double)this.size / 16.0;
            double xzRadius = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * delta)) + 1.0f) * girth + 1.0) / 2.0;
            double yRadius = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * delta)) + 1.0f) * girth + 1.0) / 2.0;
            int minX = MathHelper.func_76128_c((double)(x - xzRadius));
            int minY = MathHelper.func_76128_c((double)(y - yRadius));
            int minZ = MathHelper.func_76128_c((double)(z - xzRadius));
            int maxX = MathHelper.func_76128_c((double)(x + xzRadius));
            int maxY = MathHelper.func_76128_c((double)(y + yRadius));
            int maxZ = MathHelper.func_76128_c((double)(z + xzRadius));
            for (int dx = minX; dx <= maxX; ++dx) {
                double xDist = ((double)dx + 0.5 - x) / xzRadius;
                if (!(xDist * xDist < 1.0)) continue;
                for (int dy = minY; dy <= maxY; ++dy) {
                    double yDist = ((double)dy + 0.5 - y) / yRadius;
                    if (!(xDist * xDist + yDist * yDist < 1.0)) continue;
                    for (int dz = minZ; dz <= maxZ; ++dz) {
                        double zDist = ((double)dz + 0.5 - z) / xzRadius;
                        if (!(xDist * xDist + yDist * yDist + zDist * zDist < 1.0)) continue;
                        BlockPos setPos = new BlockPos(dx, dy, dz);
                        IBlockState state = world.func_180495_p(setPos);
                        if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, setPos, this.canReplace::test)) continue;
                        world.func_180501_a(setPos, (IBlockState)this.block.apply(state), 2);
                    }
                }
            }
        }
        return true;
    }

    public static final class StonePredicate
    implements Predicate<IBlockState> {
        private StonePredicate() {
        }

        @Override
        public boolean test(IBlockState state) {
            return state != null && state.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)).func_190912_e();
        }

        public static StonePredicate create() {
            return new StonePredicate();
        }
    }
}

