/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BiomeDetectorBase
implements IBiomeDetector {
    private boolean doScanPonds = true;
    private boolean doScanRavines = true;
    private static final int waterPoolBiomeID = Biome.func_185362_a((Biome)Biomes.field_76781_i);
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 3;
    private static final int prioritylavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<Biome> waterBiomes = new HashSet<Biome>();
    private static final Set<Biome> beachBiomes = new HashSet<Biome>();
    private static final Set<Biome> swampBiomes = new HashSet<Biome>();
    protected static Method biomeArrayMethod;

    public static void scanBiomeTypes() {
        waterBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER));
        beachBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        swampBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
    }

    public static void setBiomeArrayMethod(boolean jeidPresent) {
        try {
            biomeArrayMethod = jeidPresent ? Chunk.class.getMethod("getIntBiomeArray", new Class[0]) : ReflectionHelper.findMethod(Chunk.class, (String)"getBiomeArray", (String)"func_76605_m", (Class[])new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void setScanPonds(boolean value) {
        this.doScanPonds = value;
    }

    public void setScanRavines(boolean value) {
        this.doScanRavines = value;
    }

    int priorityForBiome(Biome biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getBiomeID(Chunk chunk) {
        int[] chunkBiomes;
        int biomeCount = Biome.field_185377_q.func_148742_b().size();
        try {
            chunkBiomes = ByteUtil.unsignedByteToIntArray(biomeArrayMethod.invoke((Object)chunk, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        HashMap<Integer, Integer> biomeOccurrences = new HashMap<Integer, Integer>(biomeCount);
        int lavaOccurrences = 0;
        int ravineOccurences = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int biomeID = chunkBiomes[x << 4 | z];
                if (this.doScanPonds && (y = chunk.func_76611_b(x, z)) > 0) {
                    Block topBlock = chunk.func_186032_a(x, y - 1, z).func_177230_c();
                    Block topBlock2 = chunk.func_186032_a(x, y, z).func_177230_c();
                    if (topBlock == Blocks.field_150355_j && !swampBiomes.contains(Biome.func_185357_a((int)biomeID))) {
                        int occurrence = biomeOccurrences.getOrDefault(waterPoolBiomeID, 0) + 3;
                        biomeOccurrences.put(waterPoolBiomeID, occurrence);
                    } else if (topBlock2 == Blocks.field_150353_l) {
                        lavaOccurrences += 6;
                    }
                }
                if (this.doScanRavines && chunk.func_76611_b(x, z) < chunk.func_177412_p().field_73011_w.func_76557_i() - 7) {
                    ravineOccurences += 12;
                }
                if (biomeID < 0 || Biome.func_185357_a((int)biomeID) == null) continue;
                int occurrence = biomeOccurrences.getOrDefault(biomeID, 0) + this.priorityForBiome(Biome.func_185357_a((int)biomeID));
                biomeOccurrences.put(biomeID, occurrence);
            }
        }
        try {
            Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
            int meanBiomeId = (Integer)meanBiome.getKey();
            int meanBiomeOccurrences = (Integer)meanBiome.getValue();
            if (meanBiomeOccurrences < ravineOccurences) {
                return ExtTileIdMap.instance().getPseudoBiomeID("ravine");
            }
            if (meanBiomeOccurrences < lavaOccurrences) {
                return ExtTileIdMap.instance().getPseudoBiomeID("lava");
            }
            return meanBiomeId;
        }
        catch (NoSuchElementException e) {
            return Biome.func_185362_a((Biome)Biomes.field_180279_ad);
        }
    }
}

