/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.advancement;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.spell.Spell;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class SpellPredicate {
    public static final SpellPredicate ANY = new SpellPredicate();
    private final Spell spell;
    private final Tier[] tiers;
    private final Element[] elements;

    public SpellPredicate() {
        this.spell = null;
        this.tiers = Tier.values();
        this.elements = Element.values();
    }

    public SpellPredicate(@Nullable Spell spell, Tier[] tiers, Element[] elements) {
        this.spell = spell;
        this.tiers = tiers;
        this.elements = elements;
    }

    public boolean test(Spell spell) {
        if (this.spell != null && spell != this.spell) {
            return false;
        }
        if (!Arrays.asList(this.tiers).contains((Object)spell.getTier())) {
            return false;
        }
        return Arrays.asList(this.elements).contains((Object)spell.getElement());
    }

    public static SpellPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            String s;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"spell");
            Spell spell = null;
            if (jsonobject.has("spell") && (spell = Spell.get(s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"spell"))) == null) {
                throw new JsonSyntaxException("Unknown spell id '" + s + "'");
            }
            Tier[] tiers = Tier.values();
            if (jsonobject.has("tiers")) {
                try {
                    JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"tiers");
                    tiers = (Tier[])Streams.stream((Iterable)array).map(je -> Tier.fromName(JsonUtils.func_151206_a((JsonElement)je, (String)"element of array tiers"))).toArray(Tier[]::new);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Incorrect spell predicate value", (Throwable)e);
                }
            }
            Element[] elements = Element.values();
            if (jsonobject.has("elements")) {
                try {
                    JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"elements");
                    elements = (Element[])Streams.stream((Iterable)array).map(je -> Element.fromName(JsonUtils.func_151206_a((JsonElement)je, (String)"element of array elements"))).toArray(Element[]::new);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Incorrect spell predicate value", (Throwable)e);
                }
            }
            return new SpellPredicate(spell, tiers, elements);
        }
        return ANY;
    }

    public static SpellPredicate[] deserializeArray(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JsonUtils.func_151207_m((JsonElement)element, (String)"spells");
            SpellPredicate[] predicates = new SpellPredicate[jsonarray.size()];
            for (int i = 0; i < predicates.length; ++i) {
                predicates[i] = SpellPredicate.deserialize(jsonarray.get(i));
            }
            return predicates;
        }
        return new SpellPredicate[0];
    }
}

