/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.tileentity.TileEntityShrineCore;
import java.util.Arrays;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPedestal
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<Element> ELEMENT = PropertyEnum.func_177706_a((String)"element", Element.class, (Enum[])Arrays.copyOfRange(Element.values(), 1, Element.values().length));
    public static final PropertyBool NATURAL = PropertyBool.func_177716_a((String)"natural");
    private static final EnumMap<Element, MapColor> map_colours = new EnumMap(Element.class);

    public BlockPedestal(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ELEMENT, (Comparable)((Object)Element.FIRE)).func_177226_a((IProperty)NATURAL, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(WizardryTabs.WIZARDRY);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
    }

    public int func_180651_a(IBlockState state) {
        return ((Element)((Object)state.func_177229_b(ELEMENT))).ordinal();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return map_colours.get(state.func_177228_b().get(ELEMENT));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_149708_J() == tab) {
            for (Element element : Arrays.copyOfRange(Element.values(), 1, Element.values().length)) {
                items.add((Object)new ItemStack((Block)this, 1, element.ordinal()));
            }
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)NATURAL) != false ? -1.0f : super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)NATURAL) != false ? 6000000.0f : super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)NATURAL);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityShrineCore();
    }

    public IBlockState func_176203_a(int metadata) {
        boolean natural = false;
        if (metadata > ELEMENT.func_177700_c().size()) {
            natural = true;
            metadata -= ELEMENT.func_177700_c().size();
        }
        Element element = Element.values()[metadata];
        if (!ELEMENT.func_177700_c().contains((Object)element)) {
            return this.func_176223_P().func_177226_a((IProperty)NATURAL, (Comparable)Boolean.valueOf(natural));
        }
        return this.func_176223_P().func_177226_a(ELEMENT, (Comparable)((Object)element)).func_177226_a((IProperty)NATURAL, (Comparable)Boolean.valueOf(natural));
    }

    public int func_176201_c(IBlockState state) {
        return ((Element)((Object)state.func_177229_b(ELEMENT))).ordinal() + ((Boolean)state.func_177229_b((IProperty)NATURAL) != false ? ELEMENT.func_177700_c().size() : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ELEMENT, NATURAL});
    }

    static {
        map_colours.put(Element.FIRE, MapColor.field_193559_aa);
        map_colours.put(Element.ICE, MapColor.field_193564_P);
        map_colours.put(Element.LIGHTNING, MapColor.field_193570_V);
        map_colours.put(Element.NECROMANCY, MapColor.field_193571_W);
        map_colours.put(Element.EARTH, MapColor.field_193573_Y);
        map_colours.put(Element.SORCERY, MapColor.field_151670_w);
        map_colours.put(Element.HEALING, MapColor.field_193565_Q);
    }
}

