/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import electroblob.wizardry.data.BlockCastingData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class DispenserCastingData
extends BlockCastingData<TileEntityDispenser> {
    @CapabilityInject(value=DispenserCastingData.class)
    private static final Capability<DispenserCastingData> DISPENSER_CASTING_CAPABILITY = null;
    private int duration;

    public DispenserCastingData() {
        this(null);
    }

    public DispenserCastingData(TileEntityDispenser dispenser) {
        super(dispenser);
    }

    public void startCasting(Spell spell, double x, double y, double z, int duration, SpellModifiers modifiers) {
        this.startCasting(spell, x, y, z, modifiers);
        this.castingTick = 1;
        this.duration = duration;
    }

    @Override
    public void stopCasting() {
        super.stopCasting();
    }

    @Override
    protected SpellCastEvent.Source getSource() {
        return SpellCastEvent.Source.DISPENSER;
    }

    @Override
    protected EnumFacing getDirection() {
        return (EnumFacing)((TileEntityDispenser)this.tileEntity).func_145831_w().func_180495_p(((TileEntityDispenser)this.tileEntity).func_174877_v()).func_177229_b((IProperty)BlockDispenser.field_176441_a);
    }

    @Override
    protected boolean shouldContinueCasting() {
        return ((TileEntityDispenser)this.tileEntity).func_145831_w().func_175640_z(((TileEntityDispenser)this.tileEntity).func_174877_v());
    }

    @Override
    public void update() {
        super.update();
        if (this.isCasting() && this.spell.isContinuous && this.castingTick > this.duration && !((TileEntityDispenser)this.tileEntity).func_145831_w().field_72995_K) {
            if (this.findNewScroll()) {
                this.duration += 120;
            } else {
                this.stopCastingAndNotify();
            }
        }
    }

    private boolean findNewScroll() {
        if (this.spell == Spells.none) {
            return false;
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < ((TileEntityDispenser)this.tileEntity).func_70302_i_(); ++i) {
            ItemStack stack = ((TileEntityDispenser)this.tileEntity).func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemScroll) || stack.func_77960_j() != this.spell.metadata()) continue;
            slots.add(i);
        }
        if (slots.isEmpty()) {
            return false;
        }
        ((TileEntityDispenser)this.tileEntity).func_70298_a(((Integer)slots.get(((TileEntityDispenser)this.tileEntity).func_145831_w().field_73012_v.nextInt(slots.size()))).intValue(), 1);
        return true;
    }

    public static DispenserCastingData get(TileEntityDispenser dispenser) {
        return (DispenserCastingData)dispenser.getCapability(DISPENSER_CASTING_CAPABILITY, null);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(DispenserCastingData.class, (Capability.IStorage)new Capability.IStorage<DispenserCastingData>(){

            public NBTBase writeNBT(Capability<DispenserCastingData> capability, DispenserCastingData instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<DispenserCastingData> capability, DispenserCastingData instance, EnumFacing side, NBTBase nbt) {
            }
        }, DispenserCastingData::new);
    }

    @SubscribeEvent
    public static void onCapabilityLoad(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityDispenser) {
            event.addCapability(new ResourceLocation("ebwizardry", "casting_data"), (ICapabilityProvider)new Provider((TileEntityDispenser)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList tileEntities = new ArrayList(event.world.field_147482_g);
            for (TileEntity tileentity : tileEntities) {
                if (!(tileentity instanceof TileEntityDispenser) || DispenserCastingData.get((TileEntityDispenser)tileentity) == null) continue;
                DispenserCastingData.get((TileEntityDispenser)tileentity).update();
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final DispenserCastingData data;

        public Provider(TileEntityDispenser dispenser) {
            this.data = new DispenserCastingData(dispenser);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == DISPENSER_CASTING_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == DISPENSER_CASTING_CAPABILITY) {
                return (T)DISPENSER_CASTING_CAPABILITY.cast((Object)this.data);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.deserializeNBT(nbt);
        }
    }
}

