/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityLightningSigil
extends EntityScaledConstruct {
    public static final String SECONDARY_RANGE = "secondary_range";
    public static final String SECONDARY_MAX_TARGETS = "secondary_max_targets";

    public EntityLightningSigil(World world) {
        super(world);
        this.func_70105_a(Spells.frost_sigil.getProperty("effect_radius").floatValue() * 2.0f, 0.2f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 600 && this.getCaster() == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(this.field_70130_N / 2.0f, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
        for (EntityLivingBase target : targets) {
            if (!this.isValidTarget((Entity)target)) continue;
            double velX = target.field_70159_w;
            double velY = target.field_70181_x;
            double velZ = target.field_70179_y;
            if (!target.func_70097_a(this.getCaster() != null ? MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.SHOCK) : DamageSource.field_76376_m, Spells.lightning_sigil.getProperty("direct_damage").floatValue() * this.damageMultiplier)) continue;
            target.field_70159_w = velX;
            target.field_70181_x = velY;
            target.field_70179_y = velZ;
            this.func_184185_a(WizardrySounds.ENTITY_LIGHTNING_SIGIL_TRIGGER, 1.0f, 1.0f);
            double seekerRange = Spells.lightning_sigil.getProperty(SECONDARY_RANGE).doubleValue();
            List<EntityLivingBase> secondaryTargets = EntityUtils.getLivingWithinRadius(seekerRange, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, this.field_70170_p);
            int j = 0;
            while ((float)j < Math.min((float)secondaryTargets.size(), Spells.lightning_sigil.getProperty(SECONDARY_MAX_TARGETS).floatValue())) {
                EntityLivingBase secondaryTarget = secondaryTargets.get(j);
                if (secondaryTarget != target && this.isValidTarget((Entity)secondaryTarget)) {
                    if (this.field_70170_p.field_72995_K) {
                        ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity((Entity)target).pos(0.0, target.field_70131_O / 2.0f, 0.0).target((Entity)secondaryTarget).spawn(this.field_70170_p);
                        ParticleBuilder.spawnShockParticles(this.field_70170_p, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                    }
                    secondaryTarget.func_184185_a(WizardrySounds.ENTITY_LIGHTNING_SIGIL_TRIGGER, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    secondaryTarget.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.SHOCK), Spells.lightning_sigil.getProperty("splash_damage").floatValue() * this.damageMultiplier);
                }
                ++j;
            }
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(15) == 0) {
            double radius = (0.5 + this.field_70146_Z.nextDouble() * 0.3) * (double)this.field_70130_N / 2.0;
            float angle = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            ParticleBuilder.create(ParticleBuilder.Type.SPARK).pos(this.field_70165_t + radius * (double)MathHelper.func_76134_b((float)angle), this.field_70163_u + 0.1, this.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle)).spawn(this.field_70170_p);
        }
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    public boolean func_90999_ad() {
        return false;
    }
}

