/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityMagicFireball
extends EntityMagicProjectile {
    protected static final int ACCELERATION_CONVERSION_FACTOR = 10;
    protected float damage = -1.0f;
    protected int burnDuration = -1;
    protected int lifetime = 16;

    public EntityMagicFireball(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setBurnDuration(int burnDuration) {
        this.burnDuration = burnDuration;
    }

    public float getDamage() {
        return this.damage == -1.0f ? Spells.fireball.getProperty("damage").floatValue() : this.damage;
    }

    public int getBurnDuration() {
        return this.burnDuration == -1 ? Spells.fireball.getProperty("burn_duration").intValue() : this.burnDuration;
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        if (!this.field_70170_p.field_72995_K) {
            Entity entityHit = rayTrace.field_72308_g;
            if (entityHit != null) {
                float damage = this.getDamage() * this.damageMultiplier;
                DamageSource source = this.getDamageSource(entityHit);
                entityHit.func_70097_a(source, damage);
                if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, entityHit) && this.getBurnDuration() > 0) {
                    entityHit.func_70015_d(this.getBurnDuration());
                }
            } else {
                BlockPos pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b);
                if (this.field_70170_p.func_175623_d(pos) && BlockUtils.canPlaceBlock((Entity)this.field_70192_c, this.field_70170_p, pos)) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
            this.func_70106_y();
        }
    }

    protected DamageSource getDamageSource(Entity entityHit) {
        return MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), MagicDamage.DamageType.FIRE).func_76349_b();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double dx = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double dy = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O + (double)(this.field_70131_O / 2.0f) - 0.1;
                double dz = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double v = 0.06;
                ParticleBuilder.create(ParticleBuilder.Type.MAGIC_FIRE).pos(this.func_174791_d().func_72441_c(dx - this.field_70159_w / 2.0, dy, dz - this.field_70179_y / 2.0)).vel(-v * dx, -v * dy, -v * dz).scale(this.field_70130_N * 2.0f).time(10).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                dx = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                dy = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O + (double)(this.field_70131_O / 2.0f) - 0.1;
                dz = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                ParticleBuilder.create(ParticleBuilder.Type.MAGIC_FIRE).pos(this.func_174791_d().func_72441_c(dx - this.field_70159_w, dy, dz - this.field_70179_y)).vel(-v * dx, -v * dy, -v * dz).scale(this.field_70130_N * 2.0f).time(10).spawn(this.field_70170_p);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3d = source.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                double speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                this.field_70159_w = vec3d.field_72450_a * speed;
                this.field_70181_x = vec3d.field_72448_b * speed;
                this.field_70179_y = vec3d.field_72449_c * speed;
                this.lifetime = 160;
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.setCaster((EntityLivingBase)source.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.lifetime);
        super.writeSpawnData(buffer);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        this.lifetime = buffer.readInt();
        super.readSpawnData(buffer);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.lifetime = nbttagcompound.func_74762_e("lifetime");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("lifetime", this.lifetime);
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (Wizardry.settings.replaceVanillaFireballs && event.getEntity() instanceof EntitySmallFireball) {
            event.setCanceled(true);
            EntityMagicFireball fireball = new EntityMagicFireball(event.getWorld());
            fireball.field_70192_c = ((EntitySmallFireball)event.getEntity()).field_70235_a;
            fireball.func_70107_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
            fireball.setDamage(5.0f);
            fireball.setBurnDuration(5);
            fireball.setLifetime(40);
            fireball.field_70159_w = ((EntitySmallFireball)event.getEntity()).field_70232_b * 10.0;
            fireball.field_70181_x = ((EntitySmallFireball)event.getEntity()).field_70233_c * 10.0;
            fireball.field_70179_y = ((EntitySmallFireball)event.getEntity()).field_70230_d * 10.0;
            event.getWorld().func_72838_d((Entity)fireball);
        }
    }
}

