/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.spell.Spell;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlayerSync
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> Wizardry.proxy.handlePlayerSyncPacket(message));
        }
        return null;
    }

    public static class Message
    implements IMessage {
        public long seed;
        public Set<Spell> spellsDiscovered;
        public int selectedMinionID;
        public Map<IVariable, Object> spellData;

        public Message() {
        }

        public Message(long seed, Set<Spell> spellsDiscovered, int selectedMinionID, Map<IVariable, Object> spellData) {
            this.seed = seed;
            this.spellsDiscovered = spellsDiscovered;
            this.selectedMinionID = selectedMinionID;
            this.spellData = spellData;
        }

        public void fromBytes(ByteBuf buf) {
            this.seed = buf.readLong();
            this.selectedMinionID = buf.readInt();
            this.spellData = new HashMap<IVariable, Object>();
            WizardData.getSyncedVariables().forEach(v -> this.spellData.put((IVariable)v, v.read(buf)));
            this.spellData.values().removeIf(Objects::isNull);
            this.spellsDiscovered = new HashSet<Spell>();
            while (buf.isReadable()) {
                this.spellsDiscovered.add(Spell.byNetworkID(buf.readInt()));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.seed);
            buf.writeInt(this.selectedMinionID);
            WizardData.getSyncedVariables().forEach(v -> v.write(buf, this.spellData.get(v)));
            if (this.spellsDiscovered == null) {
                return;
            }
            for (Spell spell : this.spellsDiscovered) {
                buf.writeInt(spell.networkID());
            }
        }
    }
}

