/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityHuskMinion;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntityStrayMinion;
import electroblob.wizardry.entity.living.EntityWitherSkeletonMinion;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Metamorphosis
extends SpellRay {
    public static final BiMap<Class<? extends EntityLivingBase>, Class<? extends EntityLivingBase>> TRANSFORMATIONS = HashBiMap.create();

    @SafeVarargs
    public static void addTransformation(Class<? extends EntityLivingBase> ... entities) {
        Class<? extends EntityLivingBase> previousEntity = entities[entities.length - 1];
        for (Class<? extends EntityLivingBase> entity : entities) {
            TRANSFORMATIONS.put(previousEntity, entity);
            previousEntity = entity;
        }
    }

    public Metamorphosis() {
        super("metamorphosis", SpellActions.POINT, false);
        this.soundValues(0.5f, 1.0f, 0.0f);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target)) {
            Class newEntityClass;
            double xPos = target.field_70165_t;
            double yPos = target.field_70163_u;
            double zPos = target.field_70161_v;
            Class clazz = newEntityClass = caster != null && caster.func_70093_af() ? (Class)TRANSFORMATIONS.inverse().get(target.getClass()) : (Class)TRANSFORMATIONS.get(target.getClass());
            if (newEntityClass == null) {
                return false;
            }
            EntityLivingBase newEntity = null;
            try {
                newEntity = (EntityLivingBase)newEntityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                Wizardry.logger.error("Error while attempting to transform entity " + target.getClass() + " to entity " + newEntityClass);
                e.printStackTrace();
            }
            if (newEntity == null) {
                return false;
            }
            if (!world.field_72995_K) {
                newEntity.func_70606_j(((EntityLivingBase)target).func_110143_aJ());
                NBTTagCompound tag = new NBTTagCompound();
                target.func_189511_e(tag);
                NBTExtras.removeUniqueId(tag, "UUID");
                newEntity.func_70020_e(tag);
                target.func_70106_y();
                newEntity.func_70107_b(xPos, yPos, zPos);
                world.func_72838_d((Entity)newEntity);
            } else {
                for (int i = 0; i < 20; ++i) {
                    ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, world.field_73012_v, xPos, yPos + 1.0, zPos, 1.0, false).clr(0.1f, 0.0f, 0.0f).spawn(world);
                }
                ParticleBuilder.create(ParticleBuilder.Type.BUFF).pos(xPos, yPos, zPos).clr(13853643).spawn(world);
            }
            this.playSound(world, (EntityLivingBase)target, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    static {
        Metamorphosis.addTransformation(EntityPig.class, EntityPigZombie.class);
        Metamorphosis.addTransformation(EntityCow.class, EntityMooshroom.class);
        Metamorphosis.addTransformation(EntityChicken.class, EntityBat.class);
        Metamorphosis.addTransformation(EntityZombie.class, EntityHusk.class);
        Metamorphosis.addTransformation(EntitySkeleton.class, EntityStray.class, EntityWitherSkeleton.class);
        Metamorphosis.addTransformation(EntitySpider.class, EntityCaveSpider.class);
        Metamorphosis.addTransformation(EntitySlime.class, EntityMagmaCube.class);
        Metamorphosis.addTransformation(EntityZombieMinion.class, EntityHuskMinion.class);
        Metamorphosis.addTransformation(EntitySkeletonMinion.class, EntityStrayMinion.class, EntityWitherSkeletonMinion.class);
    }
}

