/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;

public enum RelativeFacing {
    DOWN("down", -1),
    UP("up", -1),
    FRONT("front", 0),
    BACK("back", 2),
    LEFT("left", 3),
    RIGHT("right", 1);

    public final String name;
    private final int horizontalIndex;
    private static final RelativeFacing[] HORIZONTALS;

    private RelativeFacing(String name, int horizontalIndex) {
        this.name = name;
        this.horizontalIndex = horizontalIndex;
    }

    public static RelativeFacing relativise(EnumFacing absolute, Entity relativeTo) {
        if (absolute == EnumFacing.DOWN) {
            return DOWN;
        }
        if (absolute == EnumFacing.UP) {
            return UP;
        }
        EnumFacing look = relativeTo.func_184172_bi();
        int relativeIndex = absolute.func_176736_b() - look.func_176736_b();
        if (relativeIndex < 0) {
            relativeIndex += 4;
        }
        return HORIZONTALS[relativeIndex];
    }

    static {
        HORIZONTALS = new RelativeFacing[4];
        for (RelativeFacing facing : RelativeFacing.values()) {
            if (facing.horizontalIndex <= -1) continue;
            RelativeFacing.HORIZONTALS[facing.horizontalIndex] = facing;
        }
    }
}

