/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.integration;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.integration.CharmModule;
import com.yungnickyoung.minecraft.bettermineshafts.integration.CompatModule;
import com.yungnickyoung.minecraft.bettermineshafts.integration.RusticModule;
import com.yungnickyoung.minecraft.bettermineshafts.integration.VariedCommoditiesModule;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public class Integrations {
    public static RusticModule RUSTIC = new RusticModule();
    public static CharmModule CHARM = new CharmModule();
    public static VariedCommoditiesModule VARIED_COMMODITIES = new VariedCommoditiesModule();
    private static final List<CompatModule> MODULES_LIST = Lists.newArrayList((Object[])new CompatModule[]{RUSTIC, CHARM, VARIED_COMMODITIES});
    private static List<IBlockState> LANTERNS = Lists.newArrayList();
    private static List<IBlockState> LEFT_TORCHES = Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST)});
    private static List<IBlockState> RIGHT_TORCHES = Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST)});

    public static void update() {
        MODULES_LIST.forEach(module -> {
            if (module.shouldBeEnabled() && !module.isEnabled()) {
                module.enable();
            }
            if (!module.shouldBeEnabled() && module.isEnabled()) {
                module.disable();
            }
        });
        MODULES_LIST.stream().filter(CompatModule::isEnabled).forEach(module -> Integrations.addIfAbsent(LANTERNS, module.lanterns));
        MODULES_LIST.stream().filter(CompatModule::isEnabled).forEach(module -> Integrations.addIfAbsent(LEFT_TORCHES, module.leftTorches));
        MODULES_LIST.stream().filter(CompatModule::isEnabled).forEach(module -> Integrations.addIfAbsent(RIGHT_TORCHES, module.rightTorches));
        MODULES_LIST.stream().filter(module -> !module.isEnabled()).forEach(module -> LANTERNS.removeAll(module.lanterns));
        MODULES_LIST.stream().filter(module -> !module.isEnabled()).forEach(module -> LEFT_TORCHES.removeAll(module.leftTorches));
        MODULES_LIST.stream().filter(module -> !module.isEnabled()).forEach(module -> RIGHT_TORCHES.removeAll(module.rightTorches));
    }

    public static IBlockState getLantern(Random random) {
        if (LANTERNS.size() == 0) {
            return null;
        }
        float delta = 1.0f / (float)LANTERNS.size();
        float currBottom = 0.0f;
        float r = random.nextFloat();
        for (IBlockState lantern : LANTERNS) {
            if (r >= currBottom && r < currBottom + delta) {
                return lantern;
            }
            currBottom += delta;
        }
        return LANTERNS.get(LANTERNS.size() - 1);
    }

    public static IBlockState getLeftTorch(Random random) {
        if (LEFT_TORCHES.size() == 0) {
            return null;
        }
        float delta = 1.0f / (float)LEFT_TORCHES.size();
        float currBottom = 0.0f;
        float r = random.nextFloat();
        for (IBlockState torch : LEFT_TORCHES) {
            if (r >= currBottom && r < currBottom + delta) {
                return torch;
            }
            currBottom += delta;
        }
        return LEFT_TORCHES.get(LEFT_TORCHES.size() - 1);
    }

    public static IBlockState getRightTorch(Random random) {
        if (RIGHT_TORCHES.size() == 0) {
            return null;
        }
        float delta = 1.0f / (float)RIGHT_TORCHES.size();
        float currBottom = 0.0f;
        float r = random.nextFloat();
        for (IBlockState torch : RIGHT_TORCHES) {
            if (r >= currBottom && r < currBottom + delta) {
                return torch;
            }
            currBottom += delta;
        }
        return RIGHT_TORCHES.get(RIGHT_TORCHES.size() - 1);
    }

    private static <T> void addIfAbsent(List<T> list, T item) {
        if (!list.contains(item)) {
            list.add(item);
        }
    }

    private static <T> void addIfAbsent(List<T> list, Collection<T> items) {
        items.forEach(item -> Integrations.addIfAbsent(list, item));
    }
}

