/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.subtile.SubTileEntity;

public class SubTileGenerating
extends SubTileEntity {
    public static final int LINK_RANGE = 6;
    private static final String TAG_MANA = "mana";
    private static final String TAG_COLLECTOR_X = "collectorX";
    private static final String TAG_COLLECTOR_Y = "collectorY";
    private static final String TAG_COLLECTOR_Z = "collectorZ";
    private static final String TAG_PASSIVE_DECAY_TICKS = "passiveDecayTicks";
    protected int mana;
    public int redstoneSignal = 0;
    int sizeLastCheck = -1;
    protected TileEntity linkedCollector = null;
    public int knownMana = -1;
    public int passiveDecayTicks;
    BlockPos cachedCollectorCoordinates = null;

    public boolean acceptsRedstone() {
        return false;
    }

    @Override
    public void onUpdate() {
        int delay;
        super.onUpdate();
        this.linkCollector();
        if (this.canGeneratePassively() && (delay = this.getDelayBetweenPassiveGeneration()) > 0 && this.ticksExisted % delay == 0 && !this.supertile.func_145831_w().field_72995_K) {
            if (this.shouldSyncPassiveGeneration()) {
                this.sync();
            }
            this.addMana(this.getValueForPassiveGeneration());
        }
        this.emptyManaIntoCollector();
        if (this.acceptsRedstone()) {
            this.redstoneSignal = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                int redstoneSide = this.supertile.func_145831_w().func_175651_c(this.supertile.func_174877_v().func_177972_a(dir), dir);
                this.redstoneSignal = Math.max(this.redstoneSignal, redstoneSide);
            }
        }
        if (this.supertile.func_145831_w().field_72995_K) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 3.5;
            Color color = new Color(this.getColor());
            if (Math.random() > particleChance) {
                BotaniaAPI.internalHandler.sparkleFX(this.supertile.func_145831_w(), (double)this.supertile.func_174877_v().func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.supertile.func_174877_v().func_177956_o() + 0.5 + Math.random() * 0.5, (double)this.supertile.func_174877_v().func_177952_p() + 0.3 + Math.random() * 0.5, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random(), 5);
            }
        }
        boolean passive = this.isPassiveFlower();
        if (!this.supertile.func_145831_w().field_72995_K) {
            int muhBalance = BotaniaAPI.internalHandler.getPassiveFlowerDecay();
            if (passive && muhBalance > 0 && this.passiveDecayTicks > muhBalance) {
                IBlockState state = this.supertile.func_145831_w().func_180495_p(this.supertile.func_174877_v());
                this.supertile.func_145831_w().func_175718_b(2001, this.supertile.func_174877_v(), Block.func_176210_f((IBlockState)state));
                if (this.supertile.func_145831_w().func_180495_p(this.supertile.func_174877_v().func_177977_b()).isSideSolid((IBlockAccess)this.supertile.func_145831_w(), this.supertile.func_174877_v().func_177977_b(), EnumFacing.UP)) {
                    this.supertile.func_145831_w().func_175656_a(this.supertile.func_174877_v(), Blocks.field_150330_I.func_176223_P());
                } else {
                    this.supertile.func_145831_w().func_175698_g(this.supertile.func_174877_v());
                }
            }
        }
        if (passive) {
            ++this.passiveDecayTicks;
        }
    }

    public void linkCollector() {
        TileEntity tileAt;
        boolean needsNew = false;
        if (this.linkedCollector == null) {
            needsNew = true;
            if (this.cachedCollectorCoordinates != null) {
                needsNew = false;
                if (this.supertile.func_145831_w().func_175667_e(this.cachedCollectorCoordinates)) {
                    needsNew = true;
                    tileAt = this.supertile.func_145831_w().func_175625_s(this.cachedCollectorCoordinates);
                    if (tileAt != null && tileAt instanceof IManaCollector && !tileAt.func_145837_r()) {
                        this.linkedCollector = tileAt;
                        needsNew = false;
                    }
                    this.cachedCollectorCoordinates = null;
                }
            }
        } else {
            tileAt = this.supertile.func_145831_w().func_175625_s(this.linkedCollector.func_174877_v());
            if (tileAt != null && tileAt instanceof IManaCollector) {
                this.linkedCollector = tileAt;
            }
        }
        if (needsNew && this.ticksExisted == 1) {
            IManaNetwork network = BotaniaAPI.internalHandler.getManaNetworkInstance();
            int size = network.getAllCollectorsInWorld(this.supertile.func_145831_w()).size();
            if (BotaniaAPI.internalHandler.shouldForceCheck() || size != this.sizeLastCheck) {
                this.linkedCollector = network.getClosestCollector(this.supertile.func_174877_v(), this.supertile.func_145831_w(), 6);
                this.sizeLastCheck = size;
            }
        }
    }

    public void linkToForcefully(TileEntity collector) {
        this.linkedCollector = collector;
    }

    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.mana + mana);
    }

    public void emptyManaIntoCollector() {
        IManaCollector collector;
        if (this.linkedCollector != null && this.isValidBinding() && !(collector = (IManaCollector)this.linkedCollector).isFull() && this.mana > 0) {
            int manaval = Math.min(this.mana, collector.getMaxMana() - collector.getCurrentMana());
            this.mana -= manaval;
            collector.recieveMana(manaval);
        }
    }

    public boolean isPassiveFlower() {
        return false;
    }

    public boolean shouldSyncPassiveGeneration() {
        return false;
    }

    public boolean canGeneratePassively() {
        return false;
    }

    public int getDelayBetweenPassiveGeneration() {
        return 20;
    }

    public int getValueForPassiveGeneration() {
        return 1;
    }

    @Override
    public List<ItemStack> getDrops(List<ItemStack> list) {
        List<ItemStack> drops = super.getDrops(list);
        this.populateDropStackNBTs(drops);
        return drops;
    }

    public void populateDropStackNBTs(List<ItemStack> drops) {
        ItemStack drop;
        if (this.isPassiveFlower() && this.ticksExisted > 0 && BotaniaAPI.internalHandler.getPassiveFlowerDecay() > 0 && (drop = drops.get(0)) != null) {
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound cmp = drop.func_77978_p();
            cmp.func_74768_a(TAG_PASSIVE_DECAY_TICKS, this.passiveDecayTicks);
        }
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, entity, stack);
        if (this.isPassiveFlower()) {
            NBTTagCompound cmp = stack.func_77978_p();
            this.passiveDecayTicks = cmp.func_74762_e(TAG_PASSIVE_DECAY_TICKS);
        }
    }

    @Override
    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            this.sync();
        }
        this.knownMana = this.mana;
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, BotaniaSoundEvents.ding, SoundCategory.PLAYERS, 0.1f, 1.0f);
        return super.onWanded(player, wand);
    }

    public int getMaxMana() {
        return 20;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.passiveDecayTicks = cmp.func_74762_e(TAG_PASSIVE_DECAY_TICKS);
        int x = cmp.func_74762_e(TAG_COLLECTOR_X);
        int y = cmp.func_74762_e(TAG_COLLECTOR_Y);
        int z = cmp.func_74762_e(TAG_COLLECTOR_Z);
        this.cachedCollectorCoordinates = y < 0 ? null : new BlockPos(x, y, z);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a("ticksExisted", this.ticksExisted);
        cmp.func_74768_a(TAG_PASSIVE_DECAY_TICKS, this.passiveDecayTicks);
        if (this.cachedCollectorCoordinates != null) {
            cmp.func_74768_a(TAG_COLLECTOR_X, this.cachedCollectorCoordinates.func_177958_n());
            cmp.func_74768_a(TAG_COLLECTOR_Y, this.cachedCollectorCoordinates.func_177956_o());
            cmp.func_74768_a(TAG_COLLECTOR_Z, this.cachedCollectorCoordinates.func_177952_p());
        } else {
            int x = this.linkedCollector == null ? 0 : this.linkedCollector.func_174877_v().func_177958_n();
            int y = this.linkedCollector == null ? -1 : this.linkedCollector.func_174877_v().func_177956_o();
            int z = this.linkedCollector == null ? 0 : this.linkedCollector.func_174877_v().func_177952_p();
            cmp.func_74768_a(TAG_COLLECTOR_X, x);
            cmp.func_74768_a(TAG_COLLECTOR_Y, y);
            cmp.func_74768_a(TAG_COLLECTOR_Z, z);
        }
    }

    @Override
    public BlockPos getBinding() {
        if (this.linkedCollector == null) {
            return null;
        }
        return this.linkedCollector.func_174877_v();
    }

    @Override
    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        int range = 6;
        double dist = pos.func_177951_i((Vec3i)this.supertile.func_174877_v());
        if ((double)(range *= range) >= dist && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IManaCollector) {
            this.linkedCollector = tile;
            return true;
        }
        return false;
    }

    public boolean isValidBinding() {
        return this.linkedCollector != null && !this.linkedCollector.func_145837_r() && this.supertile.func_145831_w().func_175625_s(this.linkedCollector.func_174877_v()) == this.linkedCollector;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = I18n.func_135052_a((String)("tile.botania:flower." + this.getUnlocalizedName() + ".name"), (Object[])new Object[0]);
        int color = this.getColor();
        BotaniaAPI.internalHandler.drawComplexManaHUD(color, this.knownMana, this.getMaxMana(), name, res, BotaniaAPI.internalHandler.getBindDisplayForFlowerType(this), this.isValidBinding());
    }

    @Override
    public boolean isOvergrowthAffected() {
        return !this.isPassiveFlower();
    }
}

