/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileIncensePlate;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockIncensePlate
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.375, 0.0, 0.125, 0.625, 0.0625, 0.875);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.125, 0.0, 0.375, 0.875, 0.0625, 0.625);

    protected BlockIncensePlate() {
        super(Material.field_151575_d, "incensePlate");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.SOUTH);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 2 || meta > 5) {
            meta = 2;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing s, float xs, float ys, float zs) {
        TileIncensePlate plate = (TileIncensePlate)world.func_175625_s(pos);
        ItemStack plateStack = plate.getItemHandler().getStackInSlot(0);
        boolean did = false;
        if (world.field_72995_K) {
            return true;
        }
        if (plateStack == null && plate.acceptsItem(stack)) {
            plate.getItemHandler().setStackInSlot(0, stack.func_77946_l());
            --stack.field_77994_a;
            did = true;
        } else if (plateStack != null && !plate.burning) {
            if (stack != null && stack.func_77973_b() == Items.field_151033_d) {
                plate.ignite();
                stack.func_77972_a(1, (EntityLivingBase)player);
                did = true;
            } else {
                ItemStack addStack = plateStack.func_77946_l();
                if (!player.field_71071_by.func_70441_a(addStack)) {
                    player.func_71019_a(addStack, false);
                }
                plate.getItemHandler().setStackInSlot(0, null);
                did = true;
            }
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
        return did;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return ((TileIncensePlate)world.func_175625_s((BlockPos)pos)).comparatorOutput;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176740_k() == EnumFacing.Axis.X) {
            return X_AABB;
        }
        return Z_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileIncensePlate();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.incense;
    }
}

